/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.util.os;

import by.gdev.util.model.GPUDescription;
import by.gdev.util.model.GPUDriverVersion;
import by.gdev.util.model.GPUsDescriptionDTO;
import by.gdev.util.os.OSExecutor;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;

public class LinuxExecutor
implements OSExecutor {
    private static final Path CUDA_VERSION_PATH = Paths.get("/usr/local/cuda/version.txt", new String[0]);

    @Override
    public String execute(String command, int seconds) throws IOException, InterruptedException {
        Process p = Runtime.getRuntime().exec(command);
        p.waitFor(seconds, TimeUnit.SECONDS);
        String res = IOUtils.toString(p.getInputStream(), Charset.defaultCharset());
        p.getInputStream().close();
        return res;
    }

    @Override
    public GPUsDescriptionDTO getGPUInfo() throws IOException, InterruptedException {
        String res = this.execute("lshw -C display", 60);
        return this.getGPUInfo1(res, "product:");
    }

    @Override
    public GPUDriverVersion getGPUDriverVersion() throws IOException {
        Optional<GPUDriverVersion> op;
        if (Files.notExists(CUDA_VERSION_PATH, new LinkOption[0])) {
            return null;
        }
        String s2 = new String(Files.readAllBytes(CUDA_VERSION_PATH));
        String[] res = s2.split(" ");
        if (res.length == 3 && (op = Arrays.stream(GPUDriverVersion.values()).filter(f -> res[2].startsWith(f.getValue())).findFirst()).isPresent()) {
            return op.get();
        }
        return null;
    }

    protected GPUsDescriptionDTO getGPUInfo1(String res, String stringStart) {
        String[] params = res.split(System.lineSeparator());
        List<GPUDescription> gpus = Arrays.stream(params).map(String::toLowerCase).filter(e -> e.contains(stringStart)).map(s2 -> {
            GPUDescription g2 = new GPUDescription();
            g2.setName(s2.split(":")[1]);
            return g2;
        }).collect(Collectors.toList());
        GPUsDescriptionDTO gpusDescriptionDTO = new GPUsDescriptionDTO();
        gpusDescriptionDTO.setRawDescription(res);
        gpusDescriptionDTO.setGpus(gpus);
        return gpusDescriptionDTO;
    }
}

