/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.util;

import by.gdev.util.CheckedFunction;
import by.gdev.util.InternetServerMap;
import by.gdev.util.OSInfo;
import by.gdev.util.model.download.Metadata;
import java.awt.Desktop;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.PosixFilePermission;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JFileChooser;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.FutureRequestExecutionService;
import org.apache.http.impl.client.HttpRequestFutureTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesktopUtil {
    private static final Logger log = LoggerFactory.getLogger(DesktopUtil.class);
    private static final String PROTECTION = "protection.txt";
    private static FileLock lock;
    public static Set<PosixFilePermission> PERMISSIONS;

    public static File getSystemPath(OSInfo.OSType type, String path) {
        File file;
        String userHome = System.getProperty("user.home", ".");
        switch (type) {
            case LINUX: 
            case SOLARIS: {
                file = new File(userHome, path);
                break;
            }
            case WINDOWS: {
                String applicationData = System.getenv("APPDATA");
                String folder = applicationData != null ? applicationData : userHome;
                file = new File(folder, path);
                break;
            }
            case MACOSX: {
                file = new File(userHome, "Library/Application Support/" + path);
                break;
            }
            default: {
                file = new File(userHome, path);
            }
        }
        return file;
    }

    public static String getChecksum(byte[] array, String algorithm) throws IOException, NoSuchAlgorithmException {
        return DesktopUtil.createChecksum(array, algorithm);
    }

    public static String getChecksum(File file, String algorithm) throws IOException, NoSuchAlgorithmException {
        return DesktopUtil.createChecksum(Files.readAllBytes(file.toPath()), algorithm);
    }

    private static String createChecksum(byte[] array, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest complete = MessageDigest.getInstance(algorithm);
        complete.update(array);
        byte[] b = complete.digest();
        StringBuilder result = new StringBuilder();
        for (byte cb : b) {
            result.append(Integer.toString((cb & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }

    public static String getJavaPathByHome(boolean appendBinFolder) {
        String path = System.getProperty("java.home");
        if (appendBinFolder) {
            path = DesktopUtil.appendToJVM(path);
        }
        return path;
    }

    public static String appendToJVM(String path) {
        char separator = File.separatorChar;
        StringBuilder b = new StringBuilder(path);
        b.append(separator);
        b.append("bin").append(separator).append("java");
        if (OSInfo.getOSType().equals((Object)OSInfo.OSType.WINDOWS)) {
            b.append("w.exe");
        }
        return b.toString();
    }

    public static <T> T uncheckCall(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T, R> Function<T, R> wrap(CheckedFunction<T, R> checkedFunction) {
        return t -> {
            try {
                return checkedFunction.apply(t);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static void sleep(int milliSeconds) {
        try {
            Thread.sleep(milliSeconds);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static InternetServerMap testServers(List<String> urls, CloseableHttpClient httpclient) {
        InternetServerMap ism = new InternetServerMap();
        ExecutorService ex = Executors.newCachedThreadPool();
        int time = 1500;
        FutureRequestExecutionService requestExecutionService = new FutureRequestExecutionService(httpclient, ex);
        ex.submit(() -> ism.putAll(((Stream)urls.stream().parallel()).map(link -> {
            Exception e = null;
            String host = "";
            int time1 = time;
            long l = System.currentTimeMillis();
            for (int i = 0; i < 2; ++i) {
                try {
                    HttpGet http = new HttpGet((String)link);
                    host = http.getURI().getHost();
                    http.setConfig(RequestConfig.custom().setConnectTimeout(time1).setSocketTimeout(time1).build());
                    log.info("check internet connection {} timeout {} ms", link, (Object)time1);
                    ResponseHandler<Boolean> handler = response -> response.getStatusLine().getStatusCode() == 200;
                    HttpRequestFutureTask<Boolean> futureTask = requestExecutionService.execute(http, HttpClientContext.create(), handler);
                    Boolean isOk = (Boolean)futureTask.get(time1, TimeUnit.MILLISECONDS);
                    if (isOk.booleanValue()) {
                        log.info("passed {} within {} ms", (Object)host, (Object)(System.currentTimeMillis() - l));
                        return new AbstractMap.SimpleEntry<String, Boolean>(host, Boolean.TRUE);
                    }
                    log.info("failed {} within {} ms", (Object)host, (Object)(System.currentTimeMillis() - l));
                }
                catch (Exception e1) {
                    e = e1;
                }
                DesktopUtil.sleep(1000);
                time1 *= 3;
            }
            log.info("failed {} within {} ms", (Object)host, (Object)(System.currentTimeMillis() - l));
            return new AbstractMap.SimpleEntry<String, Boolean>(host, Boolean.FALSE);
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)))).get();
        ex.shutdown();
        return ism;
    }

    private static void createDirectory(File file) throws IOException {
        if (file.isFile()) {
            return;
        }
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
    }

    public static void diactivateDoubleDownloadingResourcesLock() throws IOException {
        if (Objects.nonNull(lock)) {
            lock.release();
        }
    }

    public static String convertListToString(String del, List<Path> list) {
        StringBuilder b = new StringBuilder();
        for (Path string : list) {
            b.append(string).append(del);
        }
        return b.toString();
    }

    public static void activeDoubleDownloadingResourcesLock(String container) throws IOException {
        FileChannel ch;
        File f = new File(container, PROTECTION);
        DesktopUtil.createDirectory(f);
        if (!f.exists()) {
            f.createNewFile();
        }
        if (Objects.isNull(lock = (ch = FileChannel.open(f.toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE)).tryLock())) {
            log.warn("Lock could not be acquired ");
            System.exit(4);
        } else {
            log.info("Locked by file {}", (Object)f.toString());
        }
    }

    public static Path getJavaRun(Path java) throws IOException {
        return Files.walk(java, new FileVisitOption[0]).filter(e -> Files.isRegularFile(e, new LinkOption[0]) && (e.endsWith("java") || e.endsWith("java.exe"))).findAny().orElseThrow(() -> new RuntimeException("java executable not found "));
    }

    public static String appendBootstrapperJvm2(String path) {
        StringBuilder b = new StringBuilder();
        if (OSInfo.getOSType() == OSInfo.OSType.MACOSX) {
            b.append("Contents").append(File.separatorChar).append("Home").append(File.separatorChar);
        }
        return DesktopUtil.appendToJVM(new File(b.toString()).getPath());
    }

    public static void openLink(OSInfo.OSType type, String uri) {
        CompletableFuture.runAsync(() -> {
            block4: {
                try {
                    Desktop.getDesktop().browse(new URI(uri));
                }
                catch (IOException | URISyntaxException e) {
                    log.warn("can't open link", e);
                    if (!type.equals((Object)OSInfo.OSType.LINUX)) break block4;
                    try {
                        Runtime.getRuntime().exec("gnome-open " + uri);
                    }
                    catch (IOException e1) {
                        log.warn("can't open link for linix", e);
                    }
                }
            }
        });
    }

    public static void initLookAndFeel() {
        block4: {
            LookAndFeel defaultLookAndFeel = null;
            try {
                defaultLookAndFeel = UIManager.getLookAndFeel();
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                new JFileChooser();
            }
            catch (Throwable t) {
                log.warn("problem with ", t);
                if (!Objects.nonNull(defaultLookAndFeel)) break block4;
                try {
                    UIManager.setLookAndFeel(defaultLookAndFeel);
                }
                catch (Throwable e) {
                    log.warn("coudn't set defualt look and feel", e);
                }
            }
        }
    }

    public static List<String> generatePath(List<String> repositories, List<Metadata> resources) {
        return repositories.stream().map(repo -> resources.stream().map(res -> String.format("%s/%s", repo, res.getRelativeUrl())).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static List<Metadata> generateMetadataForJre(String path, String jrePath) throws IOException {
        return Files.walk(Paths.get(path, jrePath), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(pr -> !pr.getFileName().toString().endsWith(".json")).map(DesktopUtil.wrap(p -> {
            Metadata m3 = new Metadata();
            m3.setSha1(DesktopUtil.getChecksum(p.toFile(), "SHA-1"));
            String relativize = Paths.get(path, new String[0]).relativize((Path)p).toString();
            m3.setPath(relativize.replace("\\", "/"));
            m3.setSize(p.toFile().length());
            return m3;
        })).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getRootFolderZip(File zip) {
        if (zip.getName().endsWith(".tar.gz")) {
            try (TarArchiveInputStream zis = new TarArchiveInputStream(new GzipCompressorInputStream(new BufferedInputStream(new FileInputStream(zip))));){
                TarArchiveEntry ze = zis.getNextTarEntry();
                String string = ze.getName();
                return string;
            }
        }
        if (!zip.getName().endsWith(".zip")) return "";
        try (ZipInputStream zis = new ZipInputStream((InputStream)new BufferedInputStream(new FileInputStream(zip)), StandardCharsets.UTF_8);){
            ZipEntry ze = zis.getNextEntry();
            String string = ze.getName();
            return string;
        }
    }

    public static String getTime(Class<?> cl) {
        try {
            String rn = cl.getName().replace('.', '/') + ".class";
            JarURLConnection j = (JarURLConnection)cl.getClassLoader().getResource(rn).openConnection();
            return new Date(j.getJarFile().getEntry("META-INF/MANIFEST.MF").getTime()).toString();
        }
        catch (Exception e) {
            return "dev";
        }
    }

    static {
        PERMISSIONS = new HashSet<PosixFilePermission>(){
            {
                this.add(PosixFilePermission.OWNER_READ);
                this.add(PosixFilePermission.OWNER_WRITE);
                this.add(PosixFilePermission.OWNER_EXECUTE);
                this.add(PosixFilePermission.OTHERS_READ);
                this.add(PosixFilePermission.OTHERS_WRITE);
                this.add(PosixFilePermission.OTHERS_EXECUTE);
                this.add(PosixFilePermission.GROUP_READ);
                this.add(PosixFilePermission.GROUP_WRITE);
                this.add(PosixFilePermission.GROUP_EXECUTE);
            }
        };
    }
}

