/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.util;

import by.gdev.util.OSInfo;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.FileAppender;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreUtil {
    private static final Logger log = LoggerFactory.getLogger(CoreUtil.class);

    public static ImageIcon getIcon(String uri) {
        return new ImageIcon(CoreUtil.getImage(uri));
    }

    public static BufferedImage getImage(String uri) {
        try {
            return ImageIO.read(CoreUtil.class.getResource(uri));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static File getDefaultWorkingDirectory() {
        return CoreUtil.getSystemRelatedDirectory("tlauncher/starter");
    }

    public static File getSystemRelatedDirectory(String path) {
        if (!OSInfo.getOSType().equals((Object)OSInfo.OSType.MACOSX)) {
            path = '.' + path;
        }
        return CoreUtil.getSystemRelatedFile(path);
    }

    public static File getSystemRelatedFile(String path) {
        File file;
        String userHome = System.getProperty("user.home", ".");
        switch (OSInfo.getOSType()) {
            case LINUX: 
            case SOLARIS: {
                file = new File(userHome, path);
                break;
            }
            case WINDOWS: {
                String applicationData = System.getenv("APPDATA");
                String folder = applicationData != null ? applicationData : userHome;
                file = new File(folder, path);
                break;
            }
            case MACOSX: {
                file = new File(userHome, "Library/Application Support/" + path);
                break;
            }
            default: {
                file = new File(userHome, path);
            }
        }
        return file;
    }

    public static Pair<String, byte[]> readFileLog() throws IOException {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        FileAppender appender = (FileAppender)lc.getLogger("ROOT").getAppender("FILE_APPENDER");
        log.info("path {}", (Object)appender.getFile());
        return Pair.of(appender.getFile(), Files.readAllBytes(Paths.get(appender.getFile(), new String[0])));
    }
}

