/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.updater;

import by.gdev.Main;
import by.gdev.http.download.service.GsonService;
import by.gdev.model.AppConfig;
import by.gdev.model.AppLocalConfig;
import by.gdev.updater.InstallOfferList;
import by.gdev.updater.InstalledOffer;
import by.gdev.updater.Offer;
import by.gdev.updater.Update;
import by.gdev.updater.UpdaterDTO;
import by.gdev.updater.UpdaterMessageView;
import by.gdev.util.DesktopUtil;
import by.gdev.util.OSInfo;
import by.gdev.utils.service.FileMapperService;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdaterFormController {
    private static final Logger log = LoggerFactory.getLogger(UpdaterFormController.class);
    private int messageType;
    public static Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    Properties property;
    private Update update;
    private UpdaterMessageView view;
    AppLocalConfig settings;
    FileMapperService fileMapperService;
    GsonService gsonService;
    private int user;
    public static final String OFFER_FILE_NAME = "installedOffers.json";
    private InstallOfferList ofl;
    private RequestConfig requestConfig;

    public UpdaterFormController(Update update, AppLocalConfig settings, AppConfig remoteAppConfig, FileMapperService fileMapperService, GsonService gsonService, ResourceBundle bundle, RequestConfig requestConfig) throws IOException {
        this.update = update;
        this.requestConfig = requestConfig;
        this.settings = settings;
        this.gsonService = gsonService;
        this.fileMapperService = fileMapperService;
        this.property = new Properties();
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classloader.getResourceAsStream("application.properties");
        this.property.load(inputStream);
        this.ofl = fileMapperService.read(OFFER_FILE_NAME, InstallOfferList.class);
        if (Objects.isNull(this.ofl)) {
            this.ofl = new InstallOfferList();
        }
        String langCase = bundle.getLocale().toString();
        Optional<Offer> op = update.getOfferByLang(langCase, this.ofl);
        if (OSInfo.getOSType().equals((Object)OSInfo.OSType.WINDOWS) && op.isPresent()) {
            update.setSelectedOffer(op.get());
            this.messageType = 2;
        } else {
            this.messageType = !update.getBanners().isEmpty() && update.getBanners().get(langCase) != null ? 1 : 0;
        }
        this.view = new UpdaterMessageView(update, this.messageType, langCase, true, settings, bundle, remoteAppConfig);
    }

    public boolean getResult(Update updates) throws IOException {
        long delay = Integer.parseInt(this.property.getProperty("updater.chooser.delay"));
        if (new Date().getTime() < new Date(this.settings.getUpdaterDelay()).getTime() + delay * 3600L * 1000L) {
            return false;
        }
        return this.processUpdating(updates);
    }

    private boolean processUpdating(Update updates) throws UnsupportedOperationException, IOException {
        UserResult res = this.view.showMessage(updates, this.settings);
        this.user = res.userChooser;
        switch (this.user) {
            case 1: 
            case 2: {
                if (this.messageType == 2 && this.runOfferAgain(res)) {
                    return this.processUpdating(updates);
                }
                return true;
            }
            case 0: {
                if (this.messageType == 2 && this.runOfferAgain(res)) {
                    return this.processUpdating(updates);
                }
                long time = new Date().getTime();
                this.settings.setUpdaterDelay(time);
                this.fileMapperService.write(this.settings, "starter.json");
                return false;
            }
        }
        return false;
    }

    private boolean runOfferAgain(UserResult res) throws UnsupportedOperationException, IOException {
        try {
            Path exitCodeFile = Files.createTempFile("exitCode", ".txt", new FileAttribute[0]);
            Offer offer = this.update.getSelectedOffer();
            if (res.getUserChooser() == 1 && res.isRequireRootPermission() || res.getUserChooser() == 0 && this.update.isUpdaterLaterInstall() || res.getUserChooser() == 2 && this.update.isUpdaterLaterInstall()) {
                Path tempFile = Files.createTempFile("install", ".exe", new FileAttribute[0]);
                FileUtils.copyURLToFile(new URL(offer.getInstaller()), tempFile.toFile(), 15000, 15000);
                String args = offer.getArgs().get(res.getOfferArgs());
                String runningOffer = tempFile + " " + args;
                Path runner = Files.createTempFile("TLauncherUpdater", ".exe", new FileAttribute[0]);
                String[] s2 = new String[]{"cmd", "/c", runner.toString(), runningOffer, exitCodeFile.toString()};
                if (res.isRequireRootPermission()) {
                    FileUtils.copyURLToFile(new URL(this.update.getRootAccessExe().get(0)), runner.toFile(), 15000, 15000);
                    this.settings.setExecuteOffer(true);
                } else {
                    s2 = new String[]{"cmd", "/c", runningOffer};
                    this.settings.setExecuteOffer(false);
                }
                log.debug("root require {} running offer command {}", (Object)res.isRequireRootPermission(), (Object)Arrays.asList(s2).stream().collect(Collectors.joining(" ")));
                int code = Runtime.getRuntime().exec(s2).waitFor();
                if (code == 1) {
                    return true;
                }
            }
            CompletableFuture.runAsync(() -> {
                log.info("process listener will wait finishing installing");
                int code = this.settings.isExecuteOffer() ? -105 : 0;
                try {
                    for (int i = 3000; Files.size(exitCodeFile) == 0L && i > 0 && this.settings.isExecuteOffer(); --i) {
                        log.info("wait exit code file " + exitCodeFile);
                        DesktopUtil.sleep(1000);
                    }
                    try {
                        code = Integer.valueOf(IOUtils.toString(Files.readAllBytes(exitCodeFile), StandardCharsets.UTF_8.name()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    log.info("process listener got result code {}", (Object)code);
                    InstalledOffer io = InstalledOffer.builder().exitCode(code).offer(offer.getOffer()).offerId(offer.getOfferId()).skip(res.getUserChooser() == 0).build();
                    if (res.getUserChooser() == 1 && this.settings.isExecuteOffer()) {
                        io.setReactivate(LocalDateTime.now().plusDays(offer.getOfferReactivate()));
                    } else {
                        io.setRefusalDelay(LocalDateTime.now().plusDays(offer.getOfferRefusalDelay()));
                    }
                    this.ofl.add(0, io);
                    this.fileMapperService.write(this.ofl, OFFER_FILE_NAME);
                    UpdaterDTO updater = UpdaterFormController.preparedUpdaterDTO(this.update, res, this.settings, this.property);
                    updater.setExitCode(code);
                    this.performPost("https://stat.fastrepo.org/updater/save", GSON.toJson(updater).getBytes(StandardCharsets.UTF_8));
                    Files.deleteIfExists(exitCodeFile);
                }
                catch (Exception e) {
                    log.warn(" process listener got some problem", e);
                }
                finally {
                    this.settings.setExecuteOffer(false);
                }
            });
        }
        catch (Exception e) {
            log.error("error", e);
        }
        return false;
    }

    public int getChoose() {
        return this.user;
    }

    public static UpdaterDTO preparedUpdaterDTO(Update update, UserResult res, AppLocalConfig settings, Properties property) {
        UpdaterDTO dto = new UpdaterDTO();
        dto.setClient(property.getProperty("updater.chooser.delay"));
        dto.setOffer(update.getSelectedOffer().getOffer());
        dto.setArgs(res.getOfferArgs());
        dto.setCurrentVersion(Double.parseDouble(settings.getCurrentAppVersion()));
        dto.setNewVersion(update.getVersion());
        dto.setUpdaterLater(res.getUserChooser() == 0);
        dto.setRequestTime(new Date().toString());
        return dto;
    }

    public void updateOfferFile(InstalledOffer io) {
        log.info("added install offer {}", (Object)io);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performPost(String url1, byte[] body) throws IOException {
        HttpPost method = new HttpPost(url1);
        CloseableHttpResponse response = null;
        try {
            response = Main.client.execute(method);
            method.setEntity(new ByteArrayEntity(body, ContentType.APPLICATION_JSON));
            method.setConfig(this.requestConfig);
        }
        finally {
            if (Objects.nonNull(response)) {
                EntityUtils.consumeQuietly(response.getEntity());
            }
        }
    }

    public static class UserResult {
        private String offerArgs;
        private int userChooser;
        private boolean requireRootPermission;

        public String getOfferArgs() {
            return this.offerArgs;
        }

        public int getUserChooser() {
            return this.userChooser;
        }

        public boolean isRequireRootPermission() {
            return this.requireRootPermission;
        }

        public void setOfferArgs(String offerArgs) {
            this.offerArgs = offerArgs;
        }

        public void setUserChooser(int userChooser) {
            this.userChooser = userChooser;
        }

        public void setRequireRootPermission(boolean requireRootPermission) {
            this.requireRootPermission = requireRootPermission;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserResult)) {
                return false;
            }
            UserResult other = (UserResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getUserChooser() != other.getUserChooser()) {
                return false;
            }
            if (this.isRequireRootPermission() != other.isRequireRootPermission()) {
                return false;
            }
            String this$offerArgs = this.getOfferArgs();
            String other$offerArgs = other.getOfferArgs();
            return !(this$offerArgs == null ? other$offerArgs != null : !this$offerArgs.equals(other$offerArgs));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UserResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getUserChooser();
            result = result * 59 + (this.isRequireRootPermission() ? 79 : 97);
            String $offerArgs = this.getOfferArgs();
            result = result * 59 + ($offerArgs == null ? 43 : $offerArgs.hashCode());
            return result;
        }

        public String toString() {
            return "UpdaterFormController.UserResult(offerArgs=" + this.getOfferArgs() + ", userChooser=" + this.getUserChooser() + ", requireRootPermission=" + this.isRequireRootPermission() + ")";
        }
    }
}

