/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.updater;

import by.gdev.updater.Banner;
import by.gdev.updater.InstallOfferList;
import by.gdev.updater.InstalledOffer;
import by.gdev.updater.Offer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Update {
    private static final Logger log = LoggerFactory.getLogger(Update.class);
    protected Map<String, String> description = new HashMap<String, String>();
    private List<Offer> offers;
    private int offerEmptyCheckboxDelay;
    private String userCountry;
    private int offerDelay;
    private double version;
    private List<String> rootAccessExe;
    private List<String> notRootAccessExe;
    private boolean updaterLaterInstall;
    private Offer selectedOffer;
    private Map<String, List<Banner>> banners;
    protected boolean mandatory;
    private Double aboveMandatoryVersion;
    private Set<Double> mandatoryUpdatedVersions = new HashSet<Double>();

    public boolean isMandatory(String appLocalConfig) {
        if (this.mandatory) {
            return true;
        }
        Double v1 = Double.valueOf(appLocalConfig);
        if (Objects.nonNull(this.aboveMandatoryVersion) && this.aboveMandatoryVersion.compareTo(v1) > 0) {
            return true;
        }
        return Objects.nonNull(this.mandatoryUpdatedVersions) && this.mandatoryUpdatedVersions.contains(v1);
    }

    public double getVersion() {
        return this.version;
    }

    public void setVersion(double version) {
        this.version = version;
    }

    public Optional<Offer> getOfferByLang(String lang, InstallOfferList io) {
        ArrayList<Offer> sortedOffers = new ArrayList<Offer>();
        ArrayList<Integer> random = new ArrayList<Integer>();
        this.offers.forEach(e -> {
            for (int i = 0; i < e.getWeight(); ++i) {
                random.add(e.getOfferId());
            }
        });
        Random r = new Random();
        sortedOffers = new ArrayList();
        while (!random.isEmpty()) {
            int value = (Integer)random.get(r.nextInt(random.size()));
            this.offers.stream().filter(e -> e.getOfferId() == value).findFirst().ifPresent(sortedOffers::add);
            random.removeIf(e -> e == value);
        }
        this.offers.stream().filter(e -> e.getWeight() == 0).forEach(sortedOffers::add);
        this.printLogOffers("sort offers by weight {}", sortedOffers);
        List<Offer> properOffers = sortedOffers.stream().filter(e -> e.getCountries().isEmpty() && !e.getCountriesExcept().contains(this.userCountry) || e.getCountries().contains(this.userCountry)).collect(Collectors.toList());
        this.printLogOffers("can install any orders from list {}", properOffers);
        List<Offer> properInstalledAgainOffers = properOffers.stream().filter(e -> {
            Optional<InstalledOffer> op = io.stream().filter(e1 -> e1.getOfferId() == e.getOfferId()).findFirst();
            return op.isPresent() ? op.get().isAllowInstalledAgain() : true;
        }).collect(Collectors.toList());
        this.printLogOffers("can install offers, will be installed {}", properInstalledAgainOffers);
        if (properInstalledAgainOffers.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(properInstalledAgainOffers.get(0));
    }

    protected void printLogOffers(String text, List<Offer> list) {
        log.debug(text, (Object)list.stream().map(e -> String.format("(%s %s)", e.getOfferId(), e.getOffer())).collect(Collectors.joining(", ")));
    }

    public String getDescription(String key) {
        return this.description == null ? null : this.description.get(key);
    }

    public Map<String, List<Banner>> getBanners() {
        return this.banners;
    }

    public void setBanners(Map<String, List<Banner>> banners) {
        this.banners = banners;
    }

    private static <T> T requireNotNull(T obj, String name) {
        if (obj == null) {
            throw new NullPointerException(name);
        }
        return obj;
    }

    public int getOfferEmptyCheckboxDelay() {
        return this.offerEmptyCheckboxDelay;
    }

    public void setOfferEmptyCheckboxDelay(int offerEmptyCheckboxDelay) {
        this.offerEmptyCheckboxDelay = offerEmptyCheckboxDelay;
    }

    public int getOfferDelay() {
        return this.offerDelay;
    }

    public void setOfferDelay(int offerDelay) {
        this.offerDelay = offerDelay;
    }

    public List<String> getRootAccessExe() {
        return this.rootAccessExe;
    }

    public void setRootAccessExe(List<String> rootAccessExe) {
        this.rootAccessExe = rootAccessExe;
    }

    public boolean isUpdaterLaterInstall() {
        return this.updaterLaterInstall;
    }

    public void setUpdaterLaterInstall(boolean updaterLaterInstall) {
        this.updaterLaterInstall = updaterLaterInstall;
    }

    public Map<String, String> getDescription() {
        return this.description;
    }

    public List<Offer> getOffers() {
        return this.offers;
    }

    public String getUserCountry() {
        return this.userCountry;
    }

    public List<String> getNotRootAccessExe() {
        return this.notRootAccessExe;
    }

    public Offer getSelectedOffer() {
        return this.selectedOffer;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public Double getAboveMandatoryVersion() {
        return this.aboveMandatoryVersion;
    }

    public Set<Double> getMandatoryUpdatedVersions() {
        return this.mandatoryUpdatedVersions;
    }

    public void setDescription(Map<String, String> description) {
        this.description = description;
    }

    public void setOffers(List<Offer> offers) {
        this.offers = offers;
    }

    public void setUserCountry(String userCountry) {
        this.userCountry = userCountry;
    }

    public void setNotRootAccessExe(List<String> notRootAccessExe) {
        this.notRootAccessExe = notRootAccessExe;
    }

    public void setSelectedOffer(Offer selectedOffer) {
        this.selectedOffer = selectedOffer;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public void setAboveMandatoryVersion(Double aboveMandatoryVersion) {
        this.aboveMandatoryVersion = aboveMandatoryVersion;
    }

    public void setMandatoryUpdatedVersions(Set<Double> mandatoryUpdatedVersions) {
        this.mandatoryUpdatedVersions = mandatoryUpdatedVersions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Update)) {
            return false;
        }
        Update other = (Update)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOfferEmptyCheckboxDelay() != other.getOfferEmptyCheckboxDelay()) {
            return false;
        }
        if (this.getOfferDelay() != other.getOfferDelay()) {
            return false;
        }
        if (Double.compare(this.getVersion(), other.getVersion()) != 0) {
            return false;
        }
        if (this.isUpdaterLaterInstall() != other.isUpdaterLaterInstall()) {
            return false;
        }
        if (this.isMandatory() != other.isMandatory()) {
            return false;
        }
        Double this$aboveMandatoryVersion = this.getAboveMandatoryVersion();
        Double other$aboveMandatoryVersion = other.getAboveMandatoryVersion();
        if (this$aboveMandatoryVersion == null ? other$aboveMandatoryVersion != null : !((Object)this$aboveMandatoryVersion).equals(other$aboveMandatoryVersion)) {
            return false;
        }
        Map<String, String> this$description = this.getDescription();
        Map<String, String> other$description = other.getDescription();
        if (this$description == null ? other$description != null : !((Object)this$description).equals(other$description)) {
            return false;
        }
        List<Offer> this$offers = this.getOffers();
        List<Offer> other$offers = other.getOffers();
        if (this$offers == null ? other$offers != null : !((Object)this$offers).equals(other$offers)) {
            return false;
        }
        String this$userCountry = this.getUserCountry();
        String other$userCountry = other.getUserCountry();
        if (this$userCountry == null ? other$userCountry != null : !this$userCountry.equals(other$userCountry)) {
            return false;
        }
        List<String> this$rootAccessExe = this.getRootAccessExe();
        List<String> other$rootAccessExe = other.getRootAccessExe();
        if (this$rootAccessExe == null ? other$rootAccessExe != null : !((Object)this$rootAccessExe).equals(other$rootAccessExe)) {
            return false;
        }
        List<String> this$notRootAccessExe = this.getNotRootAccessExe();
        List<String> other$notRootAccessExe = other.getNotRootAccessExe();
        if (this$notRootAccessExe == null ? other$notRootAccessExe != null : !((Object)this$notRootAccessExe).equals(other$notRootAccessExe)) {
            return false;
        }
        Offer this$selectedOffer = this.getSelectedOffer();
        Offer other$selectedOffer = other.getSelectedOffer();
        if (this$selectedOffer == null ? other$selectedOffer != null : !((Object)this$selectedOffer).equals(other$selectedOffer)) {
            return false;
        }
        Map<String, List<Banner>> this$banners = this.getBanners();
        Map<String, List<Banner>> other$banners = other.getBanners();
        if (this$banners == null ? other$banners != null : !((Object)this$banners).equals(other$banners)) {
            return false;
        }
        Set<Double> this$mandatoryUpdatedVersions = this.getMandatoryUpdatedVersions();
        Set<Double> other$mandatoryUpdatedVersions = other.getMandatoryUpdatedVersions();
        return !(this$mandatoryUpdatedVersions == null ? other$mandatoryUpdatedVersions != null : !((Object)this$mandatoryUpdatedVersions).equals(other$mandatoryUpdatedVersions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Update;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOfferEmptyCheckboxDelay();
        result = result * 59 + this.getOfferDelay();
        long $version = Double.doubleToLongBits(this.getVersion());
        result = result * 59 + (int)($version >>> 32 ^ $version);
        result = result * 59 + (this.isUpdaterLaterInstall() ? 79 : 97);
        result = result * 59 + (this.isMandatory() ? 79 : 97);
        Double $aboveMandatoryVersion = this.getAboveMandatoryVersion();
        result = result * 59 + ($aboveMandatoryVersion == null ? 43 : ((Object)$aboveMandatoryVersion).hashCode());
        Map<String, String> $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
        List<Offer> $offers = this.getOffers();
        result = result * 59 + ($offers == null ? 43 : ((Object)$offers).hashCode());
        String $userCountry = this.getUserCountry();
        result = result * 59 + ($userCountry == null ? 43 : $userCountry.hashCode());
        List<String> $rootAccessExe = this.getRootAccessExe();
        result = result * 59 + ($rootAccessExe == null ? 43 : ((Object)$rootAccessExe).hashCode());
        List<String> $notRootAccessExe = this.getNotRootAccessExe();
        result = result * 59 + ($notRootAccessExe == null ? 43 : ((Object)$notRootAccessExe).hashCode());
        Offer $selectedOffer = this.getSelectedOffer();
        result = result * 59 + ($selectedOffer == null ? 43 : ((Object)$selectedOffer).hashCode());
        Map<String, List<Banner>> $banners = this.getBanners();
        result = result * 59 + ($banners == null ? 43 : ((Object)$banners).hashCode());
        Set<Double> $mandatoryUpdatedVersions = this.getMandatoryUpdatedVersions();
        result = result * 59 + ($mandatoryUpdatedVersions == null ? 43 : ((Object)$mandatoryUpdatedVersions).hashCode());
        return result;
    }

    public String toString() {
        return "Update(description=" + this.getDescription() + ", offers=" + this.getOffers() + ", offerEmptyCheckboxDelay=" + this.getOfferEmptyCheckboxDelay() + ", userCountry=" + this.getUserCountry() + ", offerDelay=" + this.getOfferDelay() + ", version=" + this.getVersion() + ", rootAccessExe=" + this.getRootAccessExe() + ", notRootAccessExe=" + this.getNotRootAccessExe() + ", updaterLaterInstall=" + this.isUpdaterLaterInstall() + ", selectedOffer=" + this.getSelectedOffer() + ", banners=" + this.getBanners() + ", mandatory=" + this.isMandatory() + ", aboveMandatoryVersion=" + this.getAboveMandatoryVersion() + ", mandatoryUpdatedVersions=" + this.getMandatoryUpdatedVersions() + ")";
    }

    public abstract class SearchResult {
        protected final Update response;

        public SearchResult(Update response) {
            this.response = response;
        }

        public final Update getResponse() {
            return this.response;
        }

        public final Update getUpdater() {
            return Update.this;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{response=" + this.response + "}";
        }
    }

    public class SearchSucceeded
    extends SearchResult {
        public SearchSucceeded(Update response) {
            super((Update)Update.requireNotNull(response, "response"));
        }
    }
}

