/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.updater;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JButton;
import javax.swing.JComponent;

public class RoundUpdaterButton
extends JButton {
    private static final long serialVersionUID = 1L;
    public Color TEXT_COLOR = Color.white;
    int ARC_SIZE = 14;

    public RoundUpdaterButton(final Color background, final Color mouseUnder, String value, Color color, final int code, final AtomicInteger userChoose) {
        this.setText(value);
        this.setBackground(color);
        this.setForeground(Color.BLACK);
        this.setOpaque(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                userChoose.set(code);
                RoundUpdaterButton.this.setBackground(mouseUnder);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RoundUpdaterButton.this.setBackground(background);
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g0) {
        int x = 0;
        Graphics2D g2 = (Graphics2D)g0;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.clearRect(x, x, this.getWidth(), this.getHeight());
        g2.setColor(this.getBackground());
        g2.fillRoundRect(x, x, this.getWidth(), this.getHeight(), this.ARC_SIZE, this.ARC_SIZE);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g0.setColor(this.TEXT_COLOR);
        this.paintText(g0, this, this.getVisibleRect(), this.getText());
    }

    protected void paintText(Graphics g2, JComponent c, Rectangle textRect, String text) {
        Graphics2D g2d = (Graphics2D)g2;
        g2d.setFont(this.getFont());
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        FontMetrics fm = g2d.getFontMetrics();
        Rectangle2D r = fm.getStringBounds(text, g2d);
        int x = (this.getWidth() - (int)r.getWidth()) / 2;
        int y = (this.getHeight() - (int)r.getHeight()) / 2 + fm.getAscent();
        g2d.drawString(text, x, y);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    }
}

