/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.updater;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicProgressBarUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreloaderProgressUI
extends BasicProgressBarUI {
    private static final Logger log = LoggerFactory.getLogger(PreloaderProgressUI.class);
    public final Color border = new Color(156, 155, 155);
    public final Color bottomBorderLine = new Color(146, 154, 140);
    public final Color REST_COLOR = new Color(200, 203, 199);
    public static final int PROGRESS_HEIGHT = 24;
    public static final int PROGRESS_BAR_WIDTH = 40;
    BufferedImage bottom;
    BufferedImage top;

    public PreloaderProgressUI(BufferedImage bottom, BufferedImage top) {
        this.bottom = bottom;
        this.top = top;
    }

    @Override
    protected void paintDeterminate(Graphics g2, JComponent c) {
        Graphics2D g2d = (Graphics2D)g2.create();
        Rectangle rec = this.progressBar.getVisibleRect();
        double complete = this.progressBar.getPercentComplete();
        int width = this.progressBar.getWidth();
        int completeWidth = (int)(complete * (double)this.bottom.getWidth());
        g2d.setColor(this.REST_COLOR);
        g2d.fillRect(rec.x, rec.y, width, this.bottom.getHeight());
        if (completeWidth > 0) {
            g2d.drawImage(this.bottom, completeWidth, rec.y, width, this.bottom.getHeight(), null);
            g2d.drawImage(this.top.getSubimage(rec.x, rec.y, completeWidth, 24), rec.x, rec.y, completeWidth, this.bottom.getHeight(), null);
        }
    }

    @Override
    protected void paintIndeterminate(Graphics g2, JComponent c) {
        if (!(g2 instanceof Graphics2D)) {
            return;
        }
        Rectangle rec = null;
        try {
            Graphics2D g2d = (Graphics2D)g2;
            rec = this.progressBar.getVisibleRect();
            this.boxRect = this.getBox(this.boxRect);
            g2d.drawImage(this.bottom, rec.x, rec.y, this.bottom.getWidth(), this.bottom.getHeight(), null);
            g2d.drawImage(this.top, this.boxRect.x, this.boxRect.y, this.boxRect.width, this.boxRect.height, null);
        }
        catch (NullPointerException e) {
            log.info("bottom is null " + Objects.isNull(this.bottom));
            log.info("rec is null " + Objects.isNull(rec));
        }
    }

    @Override
    protected Rectangle getBox(Rectangle r) {
        r.x += 4;
        if (r.x > this.progressBar.getWidth()) {
            r.x = 0;
        }
        r.height = 24;
        r.width = 40;
        return r;
    }
}

