/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.updater;

import by.gdev.util.CoreUtil;
import by.gdev.util.DesktopUtil;
import by.gdev.util.OSInfo;
import java.awt.Color;
import java.awt.Insets;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class HtmlTextPane
extends JEditorPane {
    private static final HtmlTextPane HTML_TEXT_PANE = new HtmlTextPane("text/html", "");
    private static final HtmlTextPane HTML_TEXT_PANE_WIDTH = new HtmlTextPane("text/html", "");

    public HtmlTextPane(String type, String text) {
        super(type, text);
        this.getDocument().putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setForeground(Color.BLACK);
        this.setEditable(false);
        this.setOpaque(false);
        HTMLEditorKit kit = new HTMLEditorKit();
        this.setEditorKit(kit);
        this.addHyperlinkListener(e -> {
            if (!e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                return;
            }
            URL url = e.getURL();
            if (url == null) {
                return;
            }
            DesktopUtil.openLink(OSInfo.getOSType(), url.toString());
        });
    }

    public static HtmlTextPane get(String text) {
        HTML_TEXT_PANE.setText(text);
        return HTML_TEXT_PANE;
    }

    public static HtmlTextPane get(String text, int width) {
        HTMLEditorKit kit = (HTMLEditorKit)HTML_TEXT_PANE_WIDTH.getEditorKit();
        kit.getStyleSheet().addRule(String.format("body {width:%spx;}", width));
        kit.getStyleSheet().addRule("a { text-decoration: underline; color: #147de0;}");
        HTML_TEXT_PANE_WIDTH.setText(text);
        return HTML_TEXT_PANE_WIDTH;
    }

    public static HtmlTextPane getWithWidth(String text, int width) {
        HtmlTextPane h2 = new HtmlTextPane("text/html", "");
        HTMLEditorKit kit = (HTMLEditorKit)h2.getEditorKit();
        kit.getStyleSheet().addRule(String.format("body {width:%spx;}", width));
        kit.getStyleSheet().addRule("a { text-decoration: underline; color: #147de0;}");
        h2.setText(text);
        return h2;
    }

    public static HtmlTextPane createNew(String text, int width) {
        HtmlTextPane pane = new HtmlTextPane("text/html", "");
        pane.setText(text);
        HTMLEditorKit kit = (HTMLEditorKit)pane.getEditorKit();
        StyleSheet ss = new StyleSheet();
        ss.importStyleSheet(CoreUtil.class.getResource("updater.css"));
        kit.getStyleSheet().addStyleSheet(ss);
        return pane;
    }

    public static JScrollPane createNew1(String text, int width) {
        HtmlTextPane pane = new HtmlTextPane("text/html", "");
        pane.setText(text);
        HTMLEditorKit kit = (HTMLEditorKit)pane.getEditorKit();
        StyleSheet ss = new StyleSheet();
        kit.getStyleSheet().addStyleSheet(ss);
        return HtmlTextPane.wrap(pane);
    }

    public static JScrollPane createNewAndWrap(String text, int width) {
        return HtmlTextPane.wrap(HtmlTextPane.createNew(text, width));
    }

    private static JScrollPane wrap(HtmlTextPane pane) {
        JScrollPane jScrollPane = new JScrollPane(pane, 21, 31);
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.setOpaque(false);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        return jScrollPane;
    }
}

