/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.ui;

import by.gdev.http.upload.download.downloader.DownloaderStatus;
import by.gdev.http.upload.download.downloader.DownloaderStatusEnum;
import by.gdev.ui.FrameUtils;
import by.gdev.util.DesktopUtil;
import by.gdev.util.OSInfo;
import com.google.common.eventbus.Subscribe;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarterStatusFrame
extends JFrame {
    private static final Logger log = LoggerFactory.getLogger(StarterStatusFrame.class);
    private static final long serialVersionUID = 1L;
    private JProgressBar progressBar;
    private String gdevBy = "https://github.com/gdevby/desktop-starter-launch-update-bootstrap";
    private JLabel uploadStatus = new JLabel();
    private ResourceBundle resourceBundle;

    public StarterStatusFrame(final OSInfo.OSType type, String appName, boolean indeterminate, ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        this.setResizable(false);
        this.setUndecorated(true);
        this.setAlwaysOnTop(true);
        FrameUtils.setFavicons(this);
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        int width = gd.getDisplayMode().getWidth();
        int height = gd.getDisplayMode().getHeight();
        this.setSize(new Dimension(width / 5, height / 5));
        DesktopUtil.initLookAndFeel();
        JPanel p = new JPanel(new BorderLayout(0, 0));
        final BufferedImage image = this.getImage();
        JPanel background = new JPanel(new BorderLayout(0, 0)){
            private static final long serialVersionUID = 1L;

            @Override
            public void paint(Graphics g2) {
                if (Objects.nonNull(image)) {
                    g2.drawImage(image, 0, 0, this.getSize().width, this.getSize().height, null);
                }
                super.paint(g2);
            }
        };
        background.setOpaque(false);
        final JLabel label = new JLabel("app launcher gdev.by");
        label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Font f = label.getFont();
        label.setFont(f.deriveFont(1).deriveFont((float)(f.getSize() - 2)));
        p.setOpaque(true);
        JLabel nameLabel = new JLabel(appName);
        f = nameLabel.getFont();
        nameLabel.setFont(f.deriveFont((float)(f.getSize() + 5)));
        nameLabel.setHorizontalAlignment(0);
        nameLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, this.getSize().height / 3, 0));
        this.uploadStatus.setFont(this.uploadStatus.getFont().deriveFont(1));
        this.uploadStatus.setHorizontalAlignment(4);
        this.uploadStatus.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 3));
        this.progressBar = new JProgressBar();
        this.progressBar.setDoubleBuffered(true);
        this.progressBar.setIndeterminate(indeterminate);
        this.progressBar.setBorder(BorderFactory.createEmptyBorder());
        background.add((Component)nameLabel, "Center");
        background.add((Component)label, "North");
        background.add((Component)this.uploadStatus, "South");
        p.add((Component)background, "Center");
        p.add((Component)this.progressBar, "South");
        this.add(p);
        this.setLocation(width / 2 - this.getSize().width / 2, height / 2 - this.getSize().height / 2);
        label.addMouseListener(new MouseAdapter(){
            private Color c;
            {
                this.c = label.getForeground();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    DesktopUtil.openLink(type, StarterStatusFrame.this.gdevBy);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                label.setForeground(Color.BLACK);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                label.setForeground(this.c);
            }
        });
    }

    private BufferedImage getImage() {
        BufferedImage image = null;
        try {
            image = ImageIO.read(StarterStatusFrame.class.getResourceAsStream("/background.jpg"));
        }
        catch (IOException e) {
            log.warn("can't load image", e);
        }
        return image;
    }

    @Subscribe
    public void messageToSpeed(DownloaderStatus status) {
        if (this.progressBar.isIndeterminate() && DownloaderStatusEnum.WORK.equals((Object)status.getDownloaderStatusEnum())) {
            SwingUtilities.invokeLater(() -> {
                this.progressBar.setIndeterminate(false);
                this.updateUploadProgressBar(status);
            });
        } else if (!this.progressBar.isIndeterminate()) {
            SwingUtilities.invokeLater(() -> this.updateUploadProgressBar(status));
        }
    }

    private void updateUploadProgressBar(DownloaderStatus status) {
        int uploaded = (int)status.getDownloadSize() / 0x100000;
        int allUpload = (int)status.getAllDownloadSize() / 0x100000;
        this.uploadStatus.setText(String.format("%s %s/%s %s ", this.resourceBundle.getString("uploading"), uploaded, allUpload, this.resourceBundle.getString("mb")));
        this.progressBar.setMaximum(allUpload);
        this.progressBar.setValue(uploaded);
    }
}

