/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.process;

import by.gdev.model.ExceptionMessage;
import by.gdev.model.StarterAppProcess;
import by.gdev.util.DesktopUtil;
import com.google.common.eventbus.EventBus;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessMonitor
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(ProcessMonitor.class);
    private Process process;
    private EventBus listener;

    public ProcessMonitor(Process process, EventBus listener) {
        this.process = process;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InputStreamReader reader = new InputStreamReader(this.process.getInputStream());
        BufferedReader buf = new BufferedReader(reader);
        while (this.process.isAlive()) {
            try {
                String line;
                while (Objects.nonNull(line = buf.readLine())) {
                    StarterAppProcess status = new StarterAppProcess();
                    status.setLine(line);
                    status.setProcess(this.process);
                    this.listener.post(status);
                }
            }
            catch (IOException t) {
                DesktopUtil.sleep(1);
                StarterAppProcess statusError = new StarterAppProcess();
                statusError.setProcess(this.process);
                statusError.setExeption(t);
                statusError.setLine("error");
                this.listener.post(statusError);
                try {
                    int exitValue = this.process.exitValue();
                    statusError.setErrorCode(exitValue);
                }
                catch (IllegalThreadStateException s2) {
                    this.listener.post(new ExceptionMessage(s2.getMessage()));
                    statusError.setErrorCode(-3);
                    log.warn("warn", s2);
                }
            }
            finally {
                try {
                    IOUtils.close((Closeable)buf);
                }
                catch (IOException e) {
                    log.error("Error", e);
                }
            }
        }
    }

    public Process getProcess() {
        return this.process;
    }
}

