/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.model;

import by.gdev.util.DesktopUtil;
import by.gdev.util.OSInfo;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.internal.Lists;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class StarterAppConfig {
    private static final String APP_CONFIG = "appConfig.json";
    public static final String APP_CHANGES_LOG = "changes.log";
    public static final String APP_STARTER_LOCAL_CONFIG = "starter.json";
    public static final String APP_STARTER_DOMAIN_AVAILABILITY = "domainAvailability.json";
    public static final String APP_STARTER_UPDATE_CONFIG = "starterUpdateV1.json";
    public static final String ADVERTISEMENT_CONFIG = "additionalUpdateConfiguration-1.1.json";
    public static final List<String> URI_APP_CONFIG = Lists.newArrayList("https://repo.tlauncher.org/tlauncher-sources/prod/release/tlauncher/", "https://repo.fastrepo.org/tlauncher-sources/prod/release/tlauncher/", "http://advancedrepository.net/tlauncher-sources/prod/release/tlauncher/", "https://repo.tlauncher.ru/tlauncher-sources/prod/release/tlauncher/");
    private final boolean prod = true;
    @Parameter(names={"-appName"}, description="The application name, use to create directory inside home, should be in lower case")
    private String appName;
    @Parameter(names={"-memory"}, description="The size of the required free disk space to download the application")
    private long minMemorySize;
    @Parameter(names={"-uriAppConfig"}, description="URI of the directory in which appConfig.json is located, which contains all information about the application being launched, this config is used by all applications by default. URI must be specified without version, see version parameter description, should be end with /")
    private List<String> serverFile;
    @Parameter(names={"-workDirectory"}, description="Working directory where the files required for the application will be loaded and in which the application will be launched. The param used for test. The second way is to put in file with installer.  The file name is installer.properties which contains work.dir=... This is for production. The default method is DesktopUtil.getSystemPath defined with by.gdev.Main. The priority: StarterAppConfig.workDirectory, file installer.properties and default method")
    private String workDirectory;
    @Parameter(names={"-version"}, description="Specifies the version of the application to launch. Therefore, the config http://localhost:81/app/1.0/appConfig.json for version 1.0 will be used. This way we can install old versions of the application. For this you need set exactly version.")
    private String version;
    @Parameter(names={"-testURLs"}, description="List of url which use to do requests. When some url or servers are not available, it doesn't do request. It will skip for download file and to do reuests. If we have server file http://example.com/repo than this field should be http://example.com")
    private List<String> testURLs;
    @Parameter(names={"-attempts"}, description="The number of allowed attempts to restore the connection")
    private int maxAttempts;
    @Parameter(names={"-connectTimeout"}, description="Set connect timeout")
    private int connectTimeout;
    @Parameter(names={"-socketTimeout"}, description="Set socket timeout")
    private int socketTimeout;
    @Parameter(names={"-timeToLife"}, description="The time that the file is up-to-date")
    private int timeToLife;
    @Parameter(names={"-logLevel"}, description="Change log level, TRACE, DEBUG, INFO")
    private String logLevel;
    @Parameter(names={"-stop"}, description="Argument to stop the application")
    private boolean stop;
    @Parameter(names={"-logURIService"}, description="Log service which can save logs and return code. User can send code for support. Doesn't implement a backend. To activate we need to use parameter ExceptionMessage#logButton=true, See ViewSubscriber#doRequest")
    private List<String> logURIService;
    public static final StarterAppConfig DEFAULT_CONFIG = new StarterAppConfig("tlauncher", 500L, URI_APP_CONFIG, null, null, Arrays.asList("https://repo.tlauncher.org/check.bin", "https://repo.fastrepo.org/check.bin", "http://advancedrepository.net/check.bin", "https://repo.tlauncher.ru/check.bin", "https://resource.tlauncher.org/check.bin", "https://resource.fastrepo.org/check.bin", "https://page.tlauncher.org/check.bin", "https://launchermeta.mojang.com/v1/packages/3d8e55480977e32acd9844e545177e69a52f594b/pre-1.6.json", "https://stat.tlauncher.ru/check.bin", "https://stat.fastrepo.org/check.bin"), 3, 5000, 10000, 600000, "INFO", false, Arrays.asList("https://securelogger.net/save/log?clientType=USER_CODE&version=0.0", "https://securelogger.top/save/log?clientType=USER_CODE&version=0.0"));

    public String getServerFileConfig(StarterAppConfig config, String version) {
        return Objects.isNull(version) ? String.join((CharSequence)"/", APP_CONFIG) : String.join((CharSequence)"/", version, APP_CONFIG);
    }

    public void buildAbsoluteWorkDirectory(OSInfo.OSType osType) throws IOException {
        Path installer = Paths.get("installer.properties", new String[0]).toAbsolutePath();
        String dir = "";
        if (Files.exists(installer, new LinkOption[0])) {
            Properties property = new Properties();
            FileInputStream fis = new FileInputStream(String.valueOf(installer));
            property.load(fis);
            dir = property.getProperty("work.dir");
        }
        if (!StringUtils.isEmpty(this.workDirectory)) {
            this.workDirectory = Paths.get(this.workDirectory, new String[0]).toAbsolutePath().toString().concat("/");
        } else if (!StringUtils.isEmpty(dir)) {
            this.workDirectory = Paths.get(dir, new String[0]).toAbsolutePath().toString().concat("/");
        } else {
            String systemDir = "." + this.appName;
            if (osType.equals((Object)OSInfo.OSType.MACOSX)) {
                systemDir = this.appName;
            }
            this.workDirectory = DesktopUtil.getSystemPath(osType, systemDir + "/starter").getAbsolutePath().toString().concat("/");
        }
    }

    public boolean isProd() {
        return this.prod;
    }

    public String getAppName() {
        return this.appName;
    }

    public long getMinMemorySize() {
        return this.minMemorySize;
    }

    public List<String> getServerFile() {
        return this.serverFile;
    }

    public String getWorkDirectory() {
        return this.workDirectory;
    }

    public String getVersion() {
        return this.version;
    }

    public List<String> getTestURLs() {
        return this.testURLs;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getTimeToLife() {
        return this.timeToLife;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public boolean isStop() {
        return this.stop;
    }

    public List<String> getLogURIService() {
        return this.logURIService;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setMinMemorySize(long minMemorySize) {
        this.minMemorySize = minMemorySize;
    }

    public void setServerFile(List<String> serverFile) {
        this.serverFile = serverFile;
    }

    public void setWorkDirectory(String workDirectory) {
        this.workDirectory = workDirectory;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setTestURLs(List<String> testURLs) {
        this.testURLs = testURLs;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setTimeToLife(int timeToLife) {
        this.timeToLife = timeToLife;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public void setLogURIService(List<String> logURIService) {
        this.logURIService = logURIService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StarterAppConfig)) {
            return false;
        }
        StarterAppConfig other = (StarterAppConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isProd() != other.isProd()) {
            return false;
        }
        if (this.getMinMemorySize() != other.getMinMemorySize()) {
            return false;
        }
        if (this.getMaxAttempts() != other.getMaxAttempts()) {
            return false;
        }
        if (this.getConnectTimeout() != other.getConnectTimeout()) {
            return false;
        }
        if (this.getSocketTimeout() != other.getSocketTimeout()) {
            return false;
        }
        if (this.getTimeToLife() != other.getTimeToLife()) {
            return false;
        }
        if (this.isStop() != other.isStop()) {
            return false;
        }
        String this$appName = this.getAppName();
        String other$appName = other.getAppName();
        if (this$appName == null ? other$appName != null : !this$appName.equals(other$appName)) {
            return false;
        }
        List<String> this$serverFile = this.getServerFile();
        List<String> other$serverFile = other.getServerFile();
        if (this$serverFile == null ? other$serverFile != null : !((Object)this$serverFile).equals(other$serverFile)) {
            return false;
        }
        String this$workDirectory = this.getWorkDirectory();
        String other$workDirectory = other.getWorkDirectory();
        if (this$workDirectory == null ? other$workDirectory != null : !this$workDirectory.equals(other$workDirectory)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        List<String> this$testURLs = this.getTestURLs();
        List<String> other$testURLs = other.getTestURLs();
        if (this$testURLs == null ? other$testURLs != null : !((Object)this$testURLs).equals(other$testURLs)) {
            return false;
        }
        String this$logLevel = this.getLogLevel();
        String other$logLevel = other.getLogLevel();
        if (this$logLevel == null ? other$logLevel != null : !this$logLevel.equals(other$logLevel)) {
            return false;
        }
        List<String> this$logURIService = this.getLogURIService();
        List<String> other$logURIService = other.getLogURIService();
        return !(this$logURIService == null ? other$logURIService != null : !((Object)this$logURIService).equals(other$logURIService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StarterAppConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isProd() ? 79 : 97);
        long $minMemorySize = this.getMinMemorySize();
        result = result * 59 + (int)($minMemorySize >>> 32 ^ $minMemorySize);
        result = result * 59 + this.getMaxAttempts();
        result = result * 59 + this.getConnectTimeout();
        result = result * 59 + this.getSocketTimeout();
        result = result * 59 + this.getTimeToLife();
        result = result * 59 + (this.isStop() ? 79 : 97);
        String $appName = this.getAppName();
        result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
        List<String> $serverFile = this.getServerFile();
        result = result * 59 + ($serverFile == null ? 43 : ((Object)$serverFile).hashCode());
        String $workDirectory = this.getWorkDirectory();
        result = result * 59 + ($workDirectory == null ? 43 : $workDirectory.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        List<String> $testURLs = this.getTestURLs();
        result = result * 59 + ($testURLs == null ? 43 : ((Object)$testURLs).hashCode());
        String $logLevel = this.getLogLevel();
        result = result * 59 + ($logLevel == null ? 43 : $logLevel.hashCode());
        List<String> $logURIService = this.getLogURIService();
        result = result * 59 + ($logURIService == null ? 43 : ((Object)$logURIService).hashCode());
        return result;
    }

    public String toString() {
        return "StarterAppConfig(prod=" + this.isProd() + ", appName=" + this.getAppName() + ", minMemorySize=" + this.getMinMemorySize() + ", serverFile=" + this.getServerFile() + ", workDirectory=" + this.getWorkDirectory() + ", version=" + this.getVersion() + ", testURLs=" + this.getTestURLs() + ", maxAttempts=" + this.getMaxAttempts() + ", connectTimeout=" + this.getConnectTimeout() + ", socketTimeout=" + this.getSocketTimeout() + ", timeToLife=" + this.getTimeToLife() + ", logLevel=" + this.getLogLevel() + ", stop=" + this.isStop() + ", logURIService=" + this.getLogURIService() + ")";
    }

    public StarterAppConfig() {
    }

    public StarterAppConfig(String appName, long minMemorySize, List<String> serverFile, String workDirectory, String version, List<String> testURLs, int maxAttempts, int connectTimeout, int socketTimeout, int timeToLife, String logLevel, boolean stop, List<String> logURIService) {
        this.appName = appName;
        this.minMemorySize = minMemorySize;
        this.serverFile = serverFile;
        this.workDirectory = workDirectory;
        this.version = version;
        this.testURLs = testURLs;
        this.maxAttempts = maxAttempts;
        this.connectTimeout = connectTimeout;
        this.socketTimeout = socketTimeout;
        this.timeToLife = timeToLife;
        this.logLevel = logLevel;
        this.stop = stop;
        this.logURIService = logURIService;
    }
}

