/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.http.upload.download.downloader;

import by.gdev.http.upload.download.downloader.DownloaderContainer;
import by.gdev.util.DesktopUtil;
import by.gdev.util.model.download.JvmRepo;
import by.gdev.util.model.download.Metadata;
import by.gdev.util.model.download.Repo;
import by.gdev.utils.service.FileMapperService;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloaderJavaContainer
extends DownloaderContainer {
    private static final Logger log = LoggerFactory.getLogger(DownloaderJavaContainer.class);
    private FileMapperService fileMapperService;
    private String workDir;
    private String jreConfig;
    private Path runnableJreDir;
    public static String JRE_DEFAULT = "jre_default";
    public static String JRE_CONFIG = "jreConfig.json";

    public DownloaderJavaContainer(FileMapperService fileMapperService, String workDir, String jreConfig) {
        this.fileMapperService = fileMapperService;
        this.workDir = workDir;
        this.jreConfig = jreConfig;
    }

    public Path getJreDir() {
        return this.runnableJreDir;
    }

    @Override
    public void filterNotExistResoursesAndSetRepo(Repo repo, String workDirectory) throws NoSuchAlgorithmException, IOException {
        JvmRepo jvm = new JvmRepo();
        jvm.setJreDirectoryName(((JvmRepo)repo).getJreDirectoryName());
        this.repo = jvm;
        this.repo.setRepositories(repo.getRepositories());
        this.repo.setResources(Lists.newArrayList());
        for (Metadata meta : repo.getResources()) {
            Path jrePath;
            this.runnableJreDir = jrePath = Paths.get(workDirectory, JRE_DEFAULT, ((JvmRepo)repo).getJreDirectoryName());
            if (Files.exists(jrePath, new LinkOption[0])) {
                this.validateJre((JvmRepo)repo);
                continue;
            }
            this.repo.getResources().add(meta);
        }
    }

    private void validateJre(JvmRepo repo) throws IOException, NoSuchAlgorithmException {
        boolean notExistJre = true;
        if (Files.exists(Paths.get(this.workDir, JRE_DEFAULT, repo.getJreDirectoryName(), JRE_CONFIG), new LinkOption[0])) {
            notExistJre = false;
        }
        List<Object> configMetadata = new ArrayList();
        if (!notExistJre) {
            Repo repo1 = this.fileMapperService.read(Paths.get(JRE_DEFAULT, repo.getJreDirectoryName(), this.jreConfig).toString(), Repo.class);
            if (Objects.nonNull(repo1)) {
                configMetadata = repo1.getResources();
                List<Metadata> localeJreMetadata = DesktopUtil.generateMetadataForJre(this.workDir, Paths.get(JRE_DEFAULT, repo.getJreDirectoryName()).toString());
                configMetadata.removeAll(localeJreMetadata);
            } else {
                notExistJre = true;
            }
        }
        if (notExistJre || configMetadata.size() != 0) {
            Metadata m3 = repo.getResources().get(0);
            this.removeJava(Paths.get(this.workDir, m3.getPath()));
            this.repo = repo;
            log.warn("problem with jre");
        }
    }

    private void removeJava(Path path) throws IOException {
        FileUtils.deleteDirectory(Paths.get(this.workDir, JRE_DEFAULT).toFile());
        FileUtils.deleteQuietly(path.toAbsolutePath().toFile());
    }

    @Override
    public void containerAllSize(Repo repo) {
        this.containerSize = repo.getResources().stream().map(Metadata::getSize).reduce(Long::sum).orElse(0L);
    }
}

