/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.http.download.impl;

import by.gdev.http.download.model.Headers;
import by.gdev.http.download.model.RequestMetadata;
import by.gdev.http.download.service.HttpService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServiceImpl
implements HttpService {
    private static final Logger log = LoggerFactory.getLogger(HttpServiceImpl.class);
    private String proxy;
    private CloseableHttpClient httpclient;
    private int maxAttepmts;
    private final Map<Path, Lock> fileLocks = new ConcurrentHashMap<Path, Lock>();

    @Override
    public RequestMetadata getRequestByUrlAndSave(String url, Path path) throws IOException {
        log.debug("do request {}, saved to {}", (Object)url, (Object)path.toAbsolutePath().toString());
        RequestMetadata request = null;
        for (int attepmts = 0; attepmts < this.maxAttepmts; ++attepmts) {
            try {
                request = this.getResourseByUrl(url, path);
                break;
            }
            catch (SocketTimeoutException e1) {
                if (++attepmts != this.maxAttepmts) continue;
                throw new SocketTimeoutException();
            }
            catch (IOException e) {
                if (Objects.nonNull(this.proxy)) {
                    request = this.getResourseByUrl(this.proxy + url, path);
                    continue;
                }
                throw e;
            }
        }
        return request;
    }

    @Override
    public RequestMetadata getMetaByUrl(String url) throws IOException {
        RequestMetadata request = null;
        for (int attepmts = 0; attepmts < this.maxAttepmts; ++attepmts) {
            try {
                request = this.getMetadata(url);
                break;
            }
            catch (SocketTimeoutException e) {
                if (++attepmts != this.maxAttepmts) continue;
                throw new SocketTimeoutException();
            }
        }
        return request;
    }

    @Override
    public String getRequestByUrl(String url) throws IOException {
        return this.getRequestByUrl(url, null);
    }

    private String getStringByUrl(String url, Map<String, String> headers) throws IOException {
        StatusLine st;
        block7: {
            String string;
            InputStream in = null;
            HttpGet httpGet = null;
            try {
                httpGet = new HttpGet(url);
                if (Objects.nonNull(headers)) {
                    for (Map.Entry<String, String> e : headers.entrySet()) {
                        httpGet.addHeader(e.getKey(), e.getValue());
                    }
                }
                CloseableHttpResponse response = this.getResponse(httpGet);
                st = response.getStatusLine();
                if (200 != response.getStatusLine().getStatusCode()) break block7;
                in = response.getEntity().getContent();
                string = IOUtils.toString(in, StandardCharsets.UTF_8);
            }
            catch (Throwable throwable) {
                if (Objects.nonNull(httpGet)) {
                    httpGet.abort();
                }
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            if (Objects.nonNull(httpGet)) {
                httpGet.abort();
            }
            IOUtils.closeQuietly(in);
            return string;
        }
        throw new IOException(String.format("code %s phrase %s %s", st.getStatusCode(), st.getReasonPhrase(), url));
    }

    private RequestMetadata getMetadata(String url) throws IOException {
        HttpHead httpUrl = new HttpHead(url);
        CloseableHttpResponse response = this.getResponse(httpUrl);
        RequestMetadata request = this.generateRequestMetadata(response);
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestMetadata getResourseByUrl(String url, Path path) throws IOException, SocketTimeoutException {
        CloseableHttpResponse response;
        HttpGet httpGet = new HttpGet(url);
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        if (!path.toFile().getParentFile().exists()) {
            path.toFile().getParentFile().mkdirs();
        }
        Path temp = Paths.get(path.toAbsolutePath().toString() + ".temp", new String[0]);
        Lock lock = this.fileLocks.computeIfAbsent(temp, key -> new ReentrantLock());
        lock.lock();
        try {
            response = this.getResponse(httpGet);
            StatusLine st = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            if (200 != response.getStatusLine().getStatusCode()) {
                throw new IOException(String.format("code %s phrase %s", st.getStatusCode(), st.getReasonPhrase()));
            }
            in = new BufferedInputStream(entity.getContent());
            out = new BufferedOutputStream(new FileOutputStream(temp.toFile()));
            byte[] buffer = new byte[65536];
            int curread = in.read(buffer);
            while (curread != -1) {
                out.write(buffer, 0, curread);
                curread = in.read(buffer);
            }
        }
        catch (Throwable throwable) {
            if (Objects.nonNull(httpGet)) {
                httpGet.abort();
            }
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            lock.unlock();
            throw throwable;
        }
        if (Objects.nonNull(httpGet)) {
            httpGet.abort();
        }
        IOUtils.closeQuietly(in);
        IOUtils.closeQuietly(out);
        lock.unlock();
        Files.move(Paths.get(temp.toString(), new String[0]), path.toAbsolutePath(), StandardCopyOption.REPLACE_EXISTING);
        RequestMetadata requestMetadata = this.generateRequestMetadata(response);
        return requestMetadata;
    }

    private CloseableHttpResponse getResponse(HttpRequestBase http) throws IOException {
        return this.httpclient.execute(http);
    }

    private RequestMetadata generateRequestMetadata(CloseableHttpResponse response) {
        RequestMetadata requestMetadata = new RequestMetadata();
        if (response.containsHeader(Headers.ETAG.getValue())) {
            requestMetadata.setETag(response.getFirstHeader(Headers.ETAG.getValue()).getValue().replaceAll("\"", ""));
        }
        if (response.containsHeader(Headers.LASTMODIFIED.getValue())) {
            requestMetadata.setLastModified(response.getFirstHeader(Headers.LASTMODIFIED.getValue()).getValue().replaceAll("\"", ""));
        }
        return requestMetadata;
    }

    @Override
    public String getRequestByUrl(String url, Map<String, String> map) throws IOException {
        SocketTimeoutException ste = null;
        for (int attepmts = 0; attepmts < this.maxAttepmts; ++attepmts) {
            try {
                return this.getStringByUrl(url, map);
            }
            catch (SocketTimeoutException e) {
                ste = e;
                continue;
            }
        }
        throw ste;
    }

    public HttpServiceImpl(String proxy, CloseableHttpClient httpclient, int maxAttepmts) {
        this.proxy = proxy;
        this.httpclient = httpclient;
        this.maxAttepmts = maxAttepmts;
    }
}

