/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.http.download.impl;

import by.gdev.http.download.service.FileCacheService;
import by.gdev.http.download.service.GsonService;
import by.gdev.http.download.service.HttpService;
import by.gdev.util.InternetServerMap;
import com.google.gson.Gson;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GsonServiceImpl
implements GsonService {
    private Gson gson;
    private FileCacheService fileService;
    private HttpService httpService;
    private InternetServerMap workedServers;

    @Override
    public <T> T getObjectWithoutSaving(List<String> urls, String urn, Class<T> class1) throws IOException {
        return this.getObjectWithoutSaving(urls, urn, class1, null);
    }

    @Override
    public <T> T getObjectWithoutSaving(List<String> urls, String urn, Type type) throws IOException {
        return this.getObjectWithoutSaving(urls, urn, type, null);
    }

    @Override
    public <T> T getObjectWithoutSaving(List<String> urls, String urn, Class<T> class1, Map<String, String> headers) throws IOException {
        return this.doRequest(urls, urn, class1, null, headers);
    }

    @Override
    public <T> T getObjectWithoutSaving(List<String> urls, String urn, Type type, Map<String, String> headers) throws IOException {
        return this.doRequest(urls, urn, null, type, headers);
    }

    @Override
    public <T> T getObjectByUrls(List<String> urls, String urn, Class<T> class1, boolean cache) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        return this.getObjectByUrls1(urls, urn, class1, null, cache);
    }

    @Override
    public <T> T getObjectByUrls(List<String> urls, String urn, Type type, boolean cache) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        return this.getObjectByUrls1(urls, urn, null, type, cache);
    }

    @Override
    public <T> T getLocalObject(List<String> uris, String urn, Class<T> class1) throws IOException, NoSuchAlgorithmException {
        return this.getLocalObject1(uris, urn, class1, null);
    }

    @Override
    public <T> T getLocalObject(List<String> uris, String urn, Type type) throws IOException, NoSuchAlgorithmException {
        return this.getLocalObject1(uris, urn, null, type);
    }

    private <T> T getLocalObject1(List<String> uris, String urn, Class<T> class1, Type type) throws IOException, NoSuchAlgorithmException, FileNotFoundException {
        Path pathFile = this.fileService.getLocalRawObject(uris, urn);
        if (Objects.isNull(pathFile)) {
            return null;
        }
        try (InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(pathFile.toFile()), StandardCharsets.UTF_8);){
            T t = Objects.nonNull(class1) ? this.gson.fromJson((Reader)read, class1) : this.gson.fromJson((Reader)read, type);
            return t;
        }
    }

    protected <T> T getObjectByUrls1(List<String> urls, String urn, Class<T> class1, Type type, boolean cache) throws IOException, NoSuchAlgorithmException {
        Path pathFile = this.fileService.getRawObject(urls, urn, cache);
        if (Objects.isNull(pathFile)) {
            return null;
        }
        try (InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(pathFile.toFile()), StandardCharsets.UTF_8);){
            T t = Objects.nonNull(class1) ? this.gson.fromJson((Reader)read, class1) : this.gson.fromJson((Reader)read, type);
            return t;
        }
    }

    protected <T> T doRequest(List<String> urls, String urn, Class<T> class1, Type type, Map<String, String> headers) throws IOException {
        IOException ex = null;
        for (String url : this.workedServers.getAliveDomainsOrUseAll(urls)) {
            try {
                String s2 = this.httpService.getRequestByUrl(url + urn, headers);
                return Objects.nonNull(class1) ? this.gson.fromJson(s2, class1) : this.gson.fromJson(s2, type);
            }
            catch (IOException e) {
                ex = e;
            }
        }
        throw ex;
    }

    public GsonServiceImpl(Gson gson, FileCacheService fileService, HttpService httpService, InternetServerMap workedServers) {
        this.gson = gson;
        this.fileService = fileService;
        this.httpService = httpService;
        this.workedServers = workedServers;
    }
}

