/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.http.download.impl;

import by.gdev.http.download.handler.PostHandler;
import by.gdev.http.upload.download.downloader.DownloadElement;
import by.gdev.http.upload.download.downloader.DownloaderStatusEnum;
import by.gdev.util.InternetServerMap;
import com.google.common.eventbus.EventBus;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadRunnableImpl
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(DownloadRunnableImpl.class);
    private volatile DownloaderStatusEnum status;
    private Queue<DownloadElement> downloadElements;
    private List<DownloadElement> processedElements;
    private CloseableHttpClient httpclient;
    private RequestConfig requestConfig;
    private EventBus eventBus;
    private InternetServerMap workedServers;
    private int downloadMaxAttemps;
    private boolean resumeDownload;

    public DownloadRunnableImpl(Queue<DownloadElement> downloadElements, List<DownloadElement> processedElements, CloseableHttpClient httpclient, RequestConfig requestConfig, EventBus eventBus, InternetServerMap workedServers, int downloadMaxAttemps, boolean resumeDownloadFile) {
        this.downloadElements = downloadElements;
        this.processedElements = processedElements;
        this.httpclient = httpclient;
        this.requestConfig = requestConfig;
        this.eventBus = eventBus;
        this.workedServers = workedServers;
        this.downloadMaxAttemps = downloadMaxAttemps;
        this.resumeDownload = resumeDownloadFile;
    }

    @Override
    public void run() {
        DownloadElement element;
        while (this.status.equals((Object)DownloaderStatusEnum.WORK) && !this.status.equals((Object)DownloaderStatusEnum.CANCEL) && Objects.nonNull(element = this.downloadElements.poll())) {
            Throwable ex = null;
            this.processedElements.add(element);
            for (String repo : this.workedServers.getAliveDomainsOrUseAll(element.getRepo().getRepositories())) {
                try {
                    this.download(element, repo);
                    for (PostHandler h2 : element.getHandlers()) {
                        h2.postProcessDownloadElement(element);
                    }
                    ex = null;
                    break;
                }
                catch (Throwable e1) {
                    ex = e1;
                }
            }
            if (!Objects.nonNull(ex)) continue;
            element.setError(ex);
        }
    }

    /*
     * Exception decompiling
     */
    private void download(DownloadElement element, String repo) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean tryDownloadPart(DownloadElement element, File file, HttpGet httpGet) throws ClientProtocolException, IOException {
        if (file.exists() && Objects.nonNull(element.getMetadata().getSha1()) && file.length() < element.getMetadata().getSize()) {
            HttpHead hh = new HttpHead(httpGet.getURI());
            try (CloseableHttpResponse response = this.httpclient.execute(hh);){
                Header h2 = response.getFirstHeader("accept-ranges");
                if (Objects.nonNull(h2) && "bytes".equals(h2.getValue())) {
                    log.info("download part with accept-ranges current size {}, full size {}", (Object)file.length(), (Object)element.getMetadata().getSize());
                    httpGet.addHeader("Range", "bytes= " + file.length() + "-" + element.getMetadata().getSize());
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    public DownloaderStatusEnum getStatus() {
        return this.status;
    }

    public Queue<DownloadElement> getDownloadElements() {
        return this.downloadElements;
    }

    public List<DownloadElement> getProcessedElements() {
        return this.processedElements;
    }

    public CloseableHttpClient getHttpclient() {
        return this.httpclient;
    }

    public RequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public InternetServerMap getWorkedServers() {
        return this.workedServers;
    }

    public int getDownloadMaxAttemps() {
        return this.downloadMaxAttemps;
    }

    public boolean isResumeDownload() {
        return this.resumeDownload;
    }

    public void setStatus(DownloaderStatusEnum status) {
        this.status = status;
    }

    public void setDownloadElements(Queue<DownloadElement> downloadElements) {
        this.downloadElements = downloadElements;
    }

    public void setProcessedElements(List<DownloadElement> processedElements) {
        this.processedElements = processedElements;
    }

    public void setHttpclient(CloseableHttpClient httpclient) {
        this.httpclient = httpclient;
    }

    public void setRequestConfig(RequestConfig requestConfig) {
        this.requestConfig = requestConfig;
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public void setWorkedServers(InternetServerMap workedServers) {
        this.workedServers = workedServers;
    }

    public void setDownloadMaxAttemps(int downloadMaxAttemps) {
        this.downloadMaxAttemps = downloadMaxAttemps;
    }

    public void setResumeDownload(boolean resumeDownload) {
        this.resumeDownload = resumeDownload;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DownloadRunnableImpl)) {
            return false;
        }
        DownloadRunnableImpl other = (DownloadRunnableImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDownloadMaxAttemps() != other.getDownloadMaxAttemps()) {
            return false;
        }
        if (this.isResumeDownload() != other.isResumeDownload()) {
            return false;
        }
        DownloaderStatusEnum this$status = this.getStatus();
        DownloaderStatusEnum other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        Queue<DownloadElement> this$downloadElements = this.getDownloadElements();
        Queue<DownloadElement> other$downloadElements = other.getDownloadElements();
        if (this$downloadElements == null ? other$downloadElements != null : !this$downloadElements.equals(other$downloadElements)) {
            return false;
        }
        List<DownloadElement> this$processedElements = this.getProcessedElements();
        List<DownloadElement> other$processedElements = other.getProcessedElements();
        if (this$processedElements == null ? other$processedElements != null : !((Object)this$processedElements).equals(other$processedElements)) {
            return false;
        }
        CloseableHttpClient this$httpclient = this.getHttpclient();
        CloseableHttpClient other$httpclient = other.getHttpclient();
        if (this$httpclient == null ? other$httpclient != null : !this$httpclient.equals(other$httpclient)) {
            return false;
        }
        RequestConfig this$requestConfig = this.getRequestConfig();
        RequestConfig other$requestConfig = other.getRequestConfig();
        if (this$requestConfig == null ? other$requestConfig != null : !this$requestConfig.equals(other$requestConfig)) {
            return false;
        }
        EventBus this$eventBus = this.getEventBus();
        EventBus other$eventBus = other.getEventBus();
        if (this$eventBus == null ? other$eventBus != null : !this$eventBus.equals(other$eventBus)) {
            return false;
        }
        InternetServerMap this$workedServers = this.getWorkedServers();
        InternetServerMap other$workedServers = other.getWorkedServers();
        return !(this$workedServers == null ? other$workedServers != null : !((Object)this$workedServers).equals(other$workedServers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DownloadRunnableImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDownloadMaxAttemps();
        result = result * 59 + (this.isResumeDownload() ? 79 : 97);
        DownloaderStatusEnum $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        Queue<DownloadElement> $downloadElements = this.getDownloadElements();
        result = result * 59 + ($downloadElements == null ? 43 : $downloadElements.hashCode());
        List<DownloadElement> $processedElements = this.getProcessedElements();
        result = result * 59 + ($processedElements == null ? 43 : ((Object)$processedElements).hashCode());
        CloseableHttpClient $httpclient = this.getHttpclient();
        result = result * 59 + ($httpclient == null ? 43 : $httpclient.hashCode());
        RequestConfig $requestConfig = this.getRequestConfig();
        result = result * 59 + ($requestConfig == null ? 43 : $requestConfig.hashCode());
        EventBus $eventBus = this.getEventBus();
        result = result * 59 + ($eventBus == null ? 43 : $eventBus.hashCode());
        InternetServerMap $workedServers = this.getWorkedServers();
        result = result * 59 + ($workedServers == null ? 43 : ((Object)$workedServers).hashCode());
        return result;
    }

    public String toString() {
        return "DownloadRunnableImpl(status=" + (Object)((Object)this.getStatus()) + ", downloadElements=" + this.getDownloadElements() + ", processedElements=" + this.getProcessedElements() + ", httpclient=" + this.getHttpclient() + ", requestConfig=" + this.getRequestConfig() + ", eventBus=" + this.getEventBus() + ", workedServers=" + this.getWorkedServers() + ", downloadMaxAttemps=" + this.getDownloadMaxAttemps() + ", resumeDownload=" + this.isResumeDownload() + ")";
    }
}

