/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.handler;

import by.gdev.handler.ValidateEnvironment;
import by.gdev.model.ExceptionMessage;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatedPartionSize
implements ValidateEnvironment {
    private static final Logger log = LoggerFactory.getLogger(ValidatedPartionSize.class);
    private long minMemorySize;
    private File workDir;
    private ResourceBundle bundle;

    @Override
    public boolean validate() {
        try {
            FileStore store;
            long res;
            if (!this.workDir.exists()) {
                this.workDir.mkdirs();
            }
            return (res = (store = Files.getFileStore(Paths.get(this.workDir.getAbsolutePath(), new String[0]))).getUsableSpace()) > this.minMemorySize * 1024L * 1024L;
        }
        catch (IOException e) {
            log.error("Error", e);
            return true;
        }
    }

    @Override
    public ExceptionMessage getExceptionMessage() {
        Path disk = this.workDir.toPath().getRoot();
        return new ExceptionMessage(String.format(this.bundle.getString("validate.size"), disk, this.workDir.getFreeSpace() / 1024L / 1024L, disk));
    }

    public ValidatedPartionSize(long minMemorySize, File workDir, ResourceBundle bundle) {
        this.minMemorySize = minMemorySize;
        this.workDir = workDir;
        this.bundle = bundle;
    }
}

