/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.handler;

import by.gdev.handler.ValidateEnvironment;
import by.gdev.model.ExceptionMessage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateTempDir
implements ValidateEnvironment {
    private static final Logger log = LoggerFactory.getLogger(ValidateTempDir.class);
    ResourceBundle bundle;

    @Override
    public boolean validate() {
        Path folder = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
        try {
            if (Files.isRegularFile(folder, new LinkOption[0])) {
                Files.delete(folder);
            }
            if (!Files.exists(folder, new LinkOption[0])) {
                Files.createDirectory(folder, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            if (e.getMessage().contains("createScrollWrapper")) {
                return false;
            }
            log.error("Error", e);
        }
        return true;
    }

    @Override
    public ExceptionMessage getExceptionMessage() {
        return new ExceptionMessage(this.bundle.getString("validate.tempdir"));
    }

    public ValidateTempDir(ResourceBundle bundle) {
        this.bundle = bundle;
    }
}

