/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.handler;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Localise {
    private static final Logger log = LoggerFactory.getLogger(Localise.class);
    static Locale locale;

    public Locale getLocal(String lang) {
        try {
            Properties property = new Properties();
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            InputStream inputStream = classloader.getResourceAsStream("application.properties");
            property.load(inputStream);
            String language = property.getProperty("language");
            Object[] parts = language.split(",");
            if (ArrayUtils.contains(parts, lang)) {
                if (lang.contains("_")) {
                    String[] ar = lang.split("_");
                    locale = new Locale(ar[0], ar[1]);
                } else {
                    locale = new Locale.Builder().setLanguage(lang).build();
                }
            } else {
                locale = new Locale.Builder().setLanguage("en").build();
            }
        }
        catch (IOException e) {
            log.error("Error", e);
        }
        return locale;
    }
}

