/*
 * Decompiled with CFR 0.152.
 */
package by.gdev;

import by.gdev.component.Starter;
import by.gdev.handler.Localise;
import by.gdev.http.download.config.HttpClientConfig;
import by.gdev.http.upload.download.downloader.DownloaderJavaContainer;
import by.gdev.model.AppLocalConfig;
import by.gdev.model.ExceptionMessage;
import by.gdev.model.StarterAppConfig;
import by.gdev.subscruber.ConsoleSubscriber;
import by.gdev.ui.subscriber.ViewSubscriber;
import by.gdev.updater.LocalDateTimeAdapter;
import by.gdev.updater.ProgressFrame;
import by.gdev.util.CoreUtil;
import by.gdev.util.DesktopUtil;
import by.gdev.util.DesktopUtilZone;
import by.gdev.util.OSInfo;
import by.gdev.utils.service.FileMapperService;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import com.beust.jcommander.JCommander;
import com.google.common.eventbus.EventBus;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemException;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOExceptionList;
import org.apache.commons.io.IOUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    public static Gson GSON;
    public static Charset charset;
    public static CloseableHttpClient client;

    public static void main(String[] args) throws Exception {
        boolean flag = true;
        Main.checkOnInvalidPath();
        System.setProperty("java.net.preferIPv4Stack", String.valueOf(flag));
        EventBus eventBus = new EventBus();
        GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)LocalDateTime.class), new LocalDateTimeAdapter()).setPrettyPrinting().create();
        StarterAppConfig starterConfig = StarterAppConfig.DEFAULT_CONFIG;
        Main.loadLogbackConfig(starterConfig);
        JCommander.newBuilder().addObject(starterConfig).build().parse(args);
        if (Objects.isNull(starterConfig.getWorkDirectory())) {
            starterConfig.buildAbsoluteWorkDirectory(OSInfo.getOSType());
        }
        Main.loadLogbackConfig(starterConfig);
        log.info("starter was run");
        log.info("starter created {}", (Object)DesktopUtil.getTime(Main.class));
        starterConfig.setServerFile(starterConfig.getServerFile().stream().map(e -> {
            if (!e.endsWith("/")) {
                log.warn("does't end with /, will add, {}", e);
                return e + "/";
            }
            return e;
        }).collect(Collectors.toList()));
        ResourceBundle bundle = null;
        try {
            client = HttpClientConfig.getInstanceHttpClient(starterConfig.getConnectTimeout(), starterConfig.getSocketTimeout(), 5, 20);
            bundle = ResourceBundle.getBundle("application", new Localise().getLocal(Locale.getDefault().getLanguage()));
            ProgressFrame starterStatusFrame = null;
            FileMapperService fileMapperService = new FileMapperService(GSON, charset, starterConfig.getWorkDirectory());
            AppLocalConfig appLocalConfig = fileMapperService.read("starter.json", AppLocalConfig.class);
            if (Objects.nonNull(appLocalConfig) && Objects.nonNull(appLocalConfig.getLang())) {
                bundle = ResourceBundle.getBundle("application", new Localise().getLocal(appLocalConfig.getLang()));
            }
            if (!GraphicsEnvironment.isHeadless()) {
                starterStatusFrame = new ProgressFrame(Objects.isNull(appLocalConfig) ? "" : appLocalConfig.getCurrentAppVersion(), true, bundle);
                starterStatusFrame.setVisible(true);
                eventBus.register(starterStatusFrame);
                eventBus.register(new ViewSubscriber(starterStatusFrame, bundle, OSInfo.getOSType(), starterConfig));
            }
            if (starterConfig.isProd() && !starterConfig.getServerFile().equals(StarterAppConfig.URI_APP_CONFIG)) {
                String errorMessage = String.format("The prod parameter is true. You don't need to change the value of the field. Current: %s, should be: %s", starterConfig.getServerFile(), StarterAppConfig.URI_APP_CONFIG);
                throw new RuntimeException(errorMessage);
            }
            String contry = Objects.nonNull(appLocalConfig) ? appLocalConfig.getCountry() : null;
            starterConfig.setServerFile(DesktopUtilZone.removeRuZoneFromOther(contry, starterConfig.getServerFile()));
            starterConfig.setTestURLs(DesktopUtilZone.removeRuZoneFromOther(contry, starterConfig.getTestURLs()));
            Starter s2 = new Starter(eventBus, starterConfig, bundle, starterStatusFrame, appLocalConfig, fileMapperService, contry);
            eventBus.register(new ConsoleSubscriber(bundle, s2.getFileMapperService(), starterConfig, appLocalConfig, starterStatusFrame));
            s2.updateApplication();
            s2.validateEnvironmentAndAppRequirements();
            s2.prepareResources();
            s2.runApp();
        }
        catch (FileSystemException | IOExceptionList ex) {
            log.error("error", ex);
            if (Objects.nonNull(bundle)) {
                eventBus.post(new ExceptionMessage(String.format(bundle.getString("file.delete.problem"), ex.getLocalizedMessage()), String.format("https://tlauncher.org/%s/check-disk.html", bundle.getLocale().getLanguage())));
            }
        }
        catch (Throwable t) {
            log.error("error", t);
            String message = t.getMessage();
            if ("file doesn't exist".equals(message)) {
                eventBus.post(new ExceptionMessage(bundle.getString("download.error")));
            } else if (Objects.nonNull(message) && message.contains("GetIpAddrTable")) {
                eventBus.post(new ExceptionMessage(bundle.getString("get.ip.addr.table")));
            } else if (Objects.nonNull(message) && message.contains("java executable not found")) {
                String workDir = starterConfig.getWorkDirectory() + DownloaderJavaContainer.JRE_DEFAULT;
                FileUtils.deleteDirectory(Paths.get(workDir, new String[0]).toFile());
                eventBus.post(new ExceptionMessage(bundle.getString("update.message"), t, false));
            } else {
                String s1 = Objects.nonNull(starterConfig.getLogURIService()) ? "unidentified.error" : "unidentified.error.1";
                eventBus.post(new ExceptionMessage(bundle.getString(s1), t, true));
            }
            System.exit(-1);
        }
    }

    protected static void loadLogbackConfig(StarterAppConfig starterConfig) throws JoranException, IOException {
        System.setProperty("logs_dir", CoreUtil.getDefaultWorkingDirectory().toPath().toAbsolutePath().getParent().toString());
        ILoggerFactory loggerContext = LoggerFactory.getILoggerFactory();
        ((LoggerContext)loggerContext).reset();
        JoranConfigurator configurator = new JoranConfigurator();
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        InputStream configStream = classloader.getResourceAsStream("logbackFull.xml");
        configurator.setContext((Context)((Object)loggerContext));
        configurator.doConfigure(IOUtils.toInputStream(IOUtils.toString(configStream, StandardCharsets.UTF_8).replaceFirst("LOG_LEVEL", starterConfig.getLogLevel()), StandardCharsets.UTF_8));
        configStream.close();
        log.info("logs directory {}", (Object)(System.getProperty("logs_dir") + "/logs/starter/"));
    }

    private static void checkOnInvalidPath() throws UnsupportedEncodingException {
        String jarFile = new File(URLDecoder.decode(Main.class.getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8")).toString();
        if (jarFile.contains("!")) {
            String message = String.format("Java can't work with path that contains symbol '!', create new local user without characters '!'(use new local user for game) and use path without '!' characters \r\ncurrent: %1$s\r\n\r\n\u0414\u0436\u0430\u0432\u0430 \u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442 c \u043f\u0443\u0442\u044f\u043c\u0438 \u0432 \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442\u0441\u044f \u0432\u043e\u0441\u043a\u043b\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0437\u043d\u0430\u043a '!' , \u0441\u043e\u0437\u0434\u0430\u0439\u0442\u0435 \u043d\u043e\u0432\u0443\u044e \u0443\u0447\u0435\u0442\u043d\u0443\u044e \u0437\u0430\u043f\u0438\u0441\u044c \u0431\u0435\u0437 '!' \u0437\u043d\u0430\u043a\u043e\u0432(\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0435\u0451 \u0434\u043b\u044f \u0438\u0433\u0440\u044b) \u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u043f\u0443\u0442\u044c \u043a \u0444\u0430\u0439\u043b\u0443 \u0431\u0435\u0437 '!'\r\n \u0442\u0435\u043a\u0443\u0449\u0438\u0439: %1$s", jarFile);
            JOptionPane.showMessageDialog(null, message, "Error", 0);
        }
    }

    static {
        charset = StandardCharsets.UTF_8;
    }
}

