/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.util;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternetServerMap
extends ConcurrentHashMap<String, Boolean> {
    private static final Logger log = LoggerFactory.getLogger(InternetServerMap.class);
    private static final long serialVersionUID = 1L;
    private boolean availableInternet;

    public boolean isSkippedURL(String url) {
        if (!this.availableInternet) {
            return false;
        }
        if (this.keySet().stream().filter((? super T e) -> url.contains((CharSequence)e) && (Boolean)this.get(e) == false).findAny().isPresent()) {
            log.debug("skip request to server {}", (Object)url);
            return true;
        }
        return false;
    }

    public List<String> getAliveDomainsOrUseAll(List<String> list) {
        List<String> l1 = this.filter(list);
        if (l1.isEmpty()) {
            return list;
        }
        return l1;
    }

    private List<String> filter(List<String> list) {
        List<String> l1 = list.stream().filter((? super T s2) -> !this.isSkippedURL((String)s2)).collect(Collectors.toList());
        return l1;
    }

    public boolean hasInternet() {
        return this.values().stream().anyMatch(e -> e);
    }

    public boolean hasInternetForDomains(List<String> domains) {
        if (!this.availableInternet) {
            return false;
        }
        List<String> l1 = this.filter(domains);
        return !l1.isEmpty();
    }

    public void setAvailableInternet(boolean availableInternet) {
        this.availableInternet = availableInternet;
    }
}

