/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.updater;

import by.gdev.model.AppConfig;
import by.gdev.model.AppLocalConfig;
import by.gdev.updater.Banner;
import by.gdev.updater.HtmlTextPane;
import by.gdev.updater.Offer;
import by.gdev.updater.OwnImageCheckBox;
import by.gdev.updater.PointOffer;
import by.gdev.updater.RoundUpdaterButton;
import by.gdev.updater.Update;
import by.gdev.updater.UpdaterFormController;
import by.gdev.util.CoreUtil;
import by.gdev.util.DesktopUtil;
import by.gdev.util.OSInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;

public class UpdaterMessageView
extends JPanel {
    private static final long serialVersionUID = -9173760470917959755L;
    private static final JFrame frame = new JFrame();
    private static final Dimension SIZE = new Dimension(900, 600);
    private RoundUpdaterButton updater;
    private RoundUpdaterButton declineOfferUpdater;
    private RoundUpdaterButton laterUpdater;
    private RoundUpdaterButton ok;
    private JPanel down = new JPanel();
    private ImagePanel imageTop;
    private AtomicInteger userChoose = new AtomicInteger();
    public int result;
    private Map<String, String> mapCommands = new HashMap<String, String>();
    private List<JCheckBox> checkBoxList = new ArrayList<JCheckBox>();
    private ResourceBundle bundle;

    public UpdaterMessageView(Update update, int messageType, String langCase, boolean isAdmin, AppLocalConfig appLocalConfig, ResourceBundle bundle, AppConfig remoteAppConfig) throws IOException {
        this.bundle = bundle;
        boolean useButtonTupe = Objects.nonNull(update.getSelectedOffer()) && update.getSelectedOffer().isButtons();
        this.ok = new RoundUpdaterButton(new Color(107, 202, 45), new Color(91, 174, 37), "OK", new Color(107, 202, 45), 1, this.userChoose);
        String updaterKey = messageType == 2 && useButtonTupe ? "accept.and.update" : "update";
        this.updater = new RoundUpdaterButton(new Color(107, 202, 45), new Color(91, 174, 37), bundle.getString(updaterKey), new Color(107, 202, 45), 1, this.userChoose);
        this.declineOfferUpdater = new RoundUpdaterButton(new Color(107, 202, 45), new Color(91, 174, 37), bundle.getString("decline.and.update"), new Color(107, 202, 45), 3, this.userChoose);
        this.laterUpdater = new RoundUpdaterButton(new Color(235, 132, 46), new Color(200, 112, 38), bundle.getString("launcher.update.later.button"), new Color(235, 132, 46), 2, this.userChoose);
        this.ok.setFont(this.getFont().deriveFont(13.0f));
        this.updater.setFont(this.getFont().deriveFont(13.0f));
        this.declineOfferUpdater.setFont(this.getFont().deriveFont(13.0f));
        this.laterUpdater.setFont(this.getFont().deriveFont(13.0f));
        this.laterUpdater.setDoubleBuffered(true);
        this.setPreferredSize(SIZE);
        String image = messageType == 2 ? "offer.png" : (messageType == 1 ? "banner.png" : "without-banner-offer.png");
        this.imageTop = new ImagePanel(CoreUtil.getImage("/" + image), 1.0f, 1.0f, true);
        JLabel tlauncher = new JLabel("TLAUNCHER");
        tlauncher.setForeground(Color.BLACK);
        tlauncher.setFont(this.getFont().deriveFont(1, 30.0f));
        tlauncher.setHorizontalAlignment(0);
        JLabel tlauncherVersion = new JLabel(remoteAppConfig.getAppVersion());
        tlauncherVersion.setForeground(Color.BLACK);
        tlauncherVersion.setFont(this.getFont().deriveFont(1, 26.0f));
        tlauncherVersion.setHorizontalAlignment(0);
        JScrollPane message = HtmlTextPane.createNewAndWrap(update.isMandatory() ? bundle.getString("launcher.update.message.mandatory") : bundle.getString("launcher.update.message.optional"), 246);
        message.setFont(this.getFont().deriveFont(1, 20.0f));
        JScrollPane changes = HtmlTextPane.createNewAndWrap(this.getLocText(update.getDescription(), langCase), 246);
        changes.setForeground(Color.BLACK);
        JScrollPane notice = HtmlTextPane.createNewAndWrap(bundle.getString("updater.notice"), 700);
        SpringLayout spring = new SpringLayout();
        SpringLayout topSpring = new SpringLayout();
        SpringLayout downSpring = new SpringLayout();
        this.setLayout(spring);
        this.imageTop.setLayout(topSpring);
        this.down.setLayout(downSpring);
        spring.putConstraint("West", (Component)this.imageTop, 0, "West", (Component)this);
        spring.putConstraint("East", (Component)this.imageTop, 0, "East", (Component)this);
        spring.putConstraint("North", (Component)this.imageTop, 0, "North", (Component)this);
        spring.putConstraint("South", (Component)this.imageTop, 453, "North", (Component)this);
        this.add(this.imageTop);
        spring.putConstraint("West", (Component)this.down, 0, "West", (Component)this);
        spring.putConstraint("East", (Component)this.down, 0, "East", (Component)this);
        spring.putConstraint("North", (Component)this.down, 453, "North", (Component)this);
        spring.putConstraint("South", (Component)this.down, 600, "North", (Component)this);
        this.add(this.down);
        topSpring.putConstraint("West", (Component)tlauncher, 20, "West", (Component)this.imageTop);
        topSpring.putConstraint("East", (Component)tlauncher, 306, "West", (Component)this.imageTop);
        topSpring.putConstraint("North", (Component)tlauncher, 37, "North", (Component)this.imageTop);
        topSpring.putConstraint("South", (Component)tlauncher, 67, "North", (Component)this.imageTop);
        this.imageTop.add(tlauncher);
        topSpring.putConstraint("West", (Component)tlauncherVersion, 20, "West", (Component)this.imageTop);
        topSpring.putConstraint("East", (Component)tlauncherVersion, 306, "West", (Component)this.imageTop);
        topSpring.putConstraint("North", (Component)tlauncherVersion, 67, "North", (Component)this.imageTop);
        topSpring.putConstraint("South", (Component)tlauncherVersion, 97, "North", (Component)this.imageTop);
        this.imageTop.add(tlauncherVersion);
        topSpring.putConstraint("West", (Component)message, 40, "West", (Component)this.imageTop);
        topSpring.putConstraint("East", (Component)message, 286, "West", (Component)this.imageTop);
        topSpring.putConstraint("North", (Component)message, 97, "North", (Component)this.imageTop);
        topSpring.putConstraint("South", (Component)message, 160, "North", (Component)this.imageTop);
        this.imageTop.add(message);
        topSpring.putConstraint("West", (Component)changes, 40, "West", (Component)this.imageTop);
        topSpring.putConstraint("East", (Component)changes, 286, "West", (Component)this.imageTop);
        topSpring.putConstraint("North", (Component)changes, 144, "North", (Component)this.imageTop);
        topSpring.putConstraint("South", (Component)changes, -40, "South", (Component)this.imageTop);
        this.imageTop.add(changes);
        downSpring.putConstraint("West", (Component)notice, 40, "West", (Component)this.down);
        downSpring.putConstraint("East", (Component)notice, 0, "East", (Component)this.down);
        downSpring.putConstraint("North", (Component)notice, 5, "North", (Component)this.down);
        downSpring.putConstraint("South", (Component)notice, 65, "North", (Component)this.down);
        this.down.add(notice);
        JPanel jp = new JPanel(new GridLayout(1, 3, 16, 0));
        jp.setOpaque(false);
        if (update.isMandatory(appLocalConfig.getCurrentAppVersion())) {
            jp.add(this.ok);
        } else {
            if (messageType == 2 && useButtonTupe) {
                this.mapCommands.putAll(update.getSelectedOffer().getArgs());
                jp.add(this.declineOfferUpdater);
            }
            jp.add(this.updater);
            jp.add(this.laterUpdater);
        }
        int buttonsWidth = 544 / (useButtonTupe ? 5 : 2);
        downSpring.putConstraint("West", (Component)jp, buttonsWidth, "West", (Component)this.down);
        downSpring.putConstraint("East", (Component)jp, -buttonsWidth, "East", (Component)this.down);
        downSpring.putConstraint("North", (Component)jp, 86, "North", (Component)this.down);
        downSpring.putConstraint("South", (Component)jp, 123, "North", (Component)this.down);
        this.down.add(jp);
        if (messageType == 1) {
            final Banner banner = update.getBanners().get(langCase).get(0);
            JLabel imagePanel = null;
            try {
                imagePanel = new JLabel(new ImageIcon(ImageIO.read(new URL(banner.getImage()))));
                imagePanel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        DesktopUtil.openLink(OSInfo.getOSType(), banner.getClickLink());
                    }
                });
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            topSpring.putConstraint("West", imagePanel, 326, "West", (Component)this.imageTop);
            topSpring.putConstraint("East", (Component)imagePanel, 0, "East", (Component)this.imageTop);
            topSpring.putConstraint("North", (Component)imagePanel, 0, "North", (Component)this.imageTop);
            topSpring.putConstraint("South", (Component)imagePanel, 453, "North", (Component)this.imageTop);
            this.imageTop.add(imagePanel);
        } else if (messageType == 2) {
            Offer offer = update.getSelectedOffer();
            JScrollPane pane = HtmlTextPane.createNewAndWrap(this.getLocText(offer.getTopText(), langCase), 574);
            topSpring.putConstraint("West", (Component)pane, 326, "West", (Component)this.imageTop);
            topSpring.putConstraint("East", (Component)pane, 0, "East", (Component)this.imageTop);
            topSpring.putConstraint("North", (Component)pane, 0, "North", (Component)this.imageTop);
            topSpring.putConstraint("South", (Component)pane, offer.getStartCheckboxSouth(), "North", (Component)this.imageTop);
            this.imageTop.add(pane);
            int start = offer.getStartCheckboxSouth();
            for (PointOffer p : offer.getCheckBoxes()) {
                OwnImageCheckBox checkBox = new OwnImageCheckBox(this.getLocText(p.getTexts(), langCase), "/updater-checkbox-on.png", "/updater-checkbox-off.png");
                checkBox.setForeground(new Color(60, 60, 60));
                checkBox.setFont(this.getFont().deriveFont(15.0f));
                if (isAdmin) {
                    checkBox.setSelected(p.isActive());
                } else {
                    checkBox.setSelected(false);
                }
                checkBox.setIconTextGap(18);
                checkBox.setActionCommand(p.getName());
                checkBox.setVerticalAlignment(0);
                topSpring.putConstraint("West", (Component)checkBox, 378, "West", (Component)this.imageTop);
                topSpring.putConstraint("East", (Component)checkBox, 0, "East", (Component)this.imageTop);
                topSpring.putConstraint("North", (Component)checkBox, start, "North", (Component)this.imageTop);
                topSpring.putConstraint("South", (Component)checkBox, start + 39, "North", (Component)this.imageTop);
                start += 39;
                this.checkBoxList.add(checkBox);
                this.imageTop.add(checkBox);
            }
            JScrollPane downDescription = HtmlTextPane.createNewAndWrap(this.getLocText(offer.getDownText(), langCase), 574);
            topSpring.putConstraint("West", (Component)downDescription, 328, "West", (Component)this.imageTop);
            topSpring.putConstraint("East", (Component)downDescription, 0, "East", (Component)this.imageTop);
            topSpring.putConstraint("North", (Component)downDescription, 320, "North", (Component)this.imageTop);
            topSpring.putConstraint("South", (Component)downDescription, 0, "South", (Component)this.imageTop);
            this.imageTop.add(downDescription);
        }
        this.down.setBackground(Color.WHITE);
        tlauncher.setHorizontalTextPosition(2);
        this.ok.addActionListener(e -> {
            this.result = 1;
        });
        this.updater.addActionListener(e -> {
            this.result = 1;
        });
        this.laterUpdater.addActionListener(e -> {
            this.result = 0;
        });
        this.declineOfferUpdater.addActionListener(e -> {
            this.result = 2;
        });
    }

    protected String getLocText(Map<String, String> map, String lang) {
        if (map.containsKey(lang)) {
            return map.get(lang);
        }
        return map.get("en");
    }

    public UpdaterFormController.UserResult showMessage(Update updates, AppLocalConfig appLocalConfig) {
        this.result = -1;
        if (updates.isMandatory(appLocalConfig.getCurrentAppVersion())) {
            UpdaterMessageView.showMessage(this.bundle.getString("launcher.update.title"), this, new JButton[]{this.ok});
        } else {
            UpdaterMessageView.showMessage(this.bundle.getString("launcher.update.title"), this, new JButton[]{this.declineOfferUpdater, this.updater, this.laterUpdater});
        }
        UpdaterFormController.UserResult res = new UpdaterFormController.UserResult();
        res.setUserChooser(this.result);
        if (!this.mapCommands.isEmpty()) {
            if (res.getUserChooser() == 2 || res.getUserChooser() == 0) {
                res.setOfferArgs("");
            } else if (res.getUserChooser() == 1) {
                res.setOfferArgs("button");
                res.setRequireRootPermission(true);
            }
        } else {
            StringBuilder builder = new StringBuilder();
            for (JCheckBox box : this.checkBoxList) {
                if (!box.isSelected()) continue;
                if (builder.length() > 0) {
                    builder.append("+");
                }
                builder.append(box.getActionCommand());
                res.setRequireRootPermission(true);
            }
            res.setOfferArgs(builder.toString());
        }
        return res;
    }

    public static void showMessage(String title, JPanel content, JButton[] buttons) {
        JDialog jDialog = new JDialog((Frame)frame, title);
        Arrays.stream(buttons).forEach(e -> e.addActionListener(a -> jDialog.setVisible(false)));
        jDialog.setAlwaysOnTop(true);
        jDialog.setResizable(false);
        jDialog.setContentPane(content);
        jDialog.setModal(true);
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        jDialog.setVisible(true);
    }

    public static void addListener(final JButton changes, final Color color) {
        changes.addActionListener(e -> {
            JOptionPane pane = UpdaterMessageView.getOptionPane((JComponent)e.getSource());
            pane.setValue(changes);
        });
        changes.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                changes.setBackground(color);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                changes.setBackground(changes.getBackground());
            }
        });
    }

    protected static JOptionPane getOptionPane(JComponent parent) {
        JOptionPane pane = !(parent instanceof JOptionPane) ? UpdaterMessageView.getOptionPane((JComponent)parent.getParent()) : (JOptionPane)parent;
        return pane;
    }

    public int getUserChoose() {
        return this.userChoose.get();
    }

    static {
        frame.setAlwaysOnTop(true);
    }

    public class ImagePanel
    extends JComponent {
        private static final long serialVersionUID = 1L;
        public static final float DEFAULT_ACTIVE_OPACITY = 1.0f;
        public static final float DEFAULT_NON_ACTIVE_OPACITY = 0.75f;
        protected final Object animationLock = new Object();
        private Image originalImage;
        private Image image;
        private boolean antiAlias;
        private boolean shown;
        private boolean animating;

        public ImagePanel(String image, float activeOpacity, float nonActiveOpacity, boolean shown) {
            this(CoreUtil.getImage(image), activeOpacity, nonActiveOpacity, shown);
        }

        public ImagePanel(Image image, float activeOpacity, float nonActiveOpacity, boolean shown) {
            this.setImage(image);
            this.setActiveOpacity(activeOpacity);
            this.setNonActiveOpacity(nonActiveOpacity);
            this.shown = shown;
            this.setBackground(new Color(0, 0, 0, 0));
            this.addMouseListenerOriginally(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ImagePanel.this.onClick();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    ImagePanel.this.onMouseEntered();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ImagePanel.this.onMouseExited();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setImage(Image image, boolean resetSize) {
            Object object = this.animationLock;
            synchronized (object) {
                this.originalImage = image;
                this.image = image;
                if (resetSize && image != null) {
                    this.setSize(image.getWidth(null), image.getHeight(null));
                }
            }
        }

        protected void setImage(Image image) {
            this.setImage(image, true);
        }

        protected void setActiveOpacity(float opacity) {
            if (opacity > 1.0f || opacity < 0.0f) {
                throw new IllegalArgumentException("Invalid opacity! Condition: 0.0F <= opacity (got: " + opacity + ") <= 1.0F");
            }
        }

        protected void setNonActiveOpacity(float opacity) {
            if (opacity > 1.0f || opacity < 0.0f) {
                throw new IllegalArgumentException("Invalid opacity! Condition: 0.0F <= opacity (got: " + opacity + ") <= 1.0F");
            }
        }

        protected boolean onClick() {
            return this.shown;
        }

        protected void onMouseEntered() {
            if (this.animating || !this.shown) {
                return;
            }
            this.repaint();
        }

        protected void onMouseExited() {
            if (this.animating || !this.shown) {
                return;
            }
            this.repaint();
        }

        public synchronized void addMouseListenerOriginally(MouseListener listener) {
            super.addMouseListener(listener);
        }

        @Override
        public void paintComponent(Graphics g0) {
            if (this.image == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g0;
            Composite oldComp = g2.getComposite();
            g2.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), null);
            g2.setComposite(oldComp);
        }
    }
}

