/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.updater;

import by.gdev.http.upload.download.downloader.DownloaderStatus;
import by.gdev.http.upload.download.downloader.DownloaderStatusEnum;
import by.gdev.updater.PreloaderProgressUI;
import by.gdev.util.CoreUtil;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;

public class ProgressFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final int WIDTH = 240;
    private static final int HEIGHT = 114;
    private Font font = new Font("Verdana", 0, 10);
    private String version_info;
    private JProgressBar progressBar;
    public final Color VERSION_BACKGROUND = new Color(40, 134, 187);
    private ResourceBundle resourceBundle;
    private JLabel uploadStatus = new JLabel();
    private JLabel version;

    @Inject
    public ProgressFrame(String info, boolean indeterminate, ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        this.getContentPane().setForeground(Color.LIGHT_GRAY);
        this.setTitle("TLauncher");
        this.setSize(240, 114);
        this.setLocationRelativeTo(null);
        this.setUndecorated(true);
        this.setResizable(false);
        this.setBackground(Color.LIGHT_GRAY);
        this.setDefaultCloseOperation(3);
        this.version_info = info;
        SpringLayout springLayout = new SpringLayout();
        this.getContentPane().setLayout(springLayout);
        this.getContentPane().setPreferredSize(new Dimension(240, 114));
        this.uploadStatus.setFont(this.uploadStatus.getFont().deriveFont(1));
        this.uploadStatus.setForeground(Color.WHITE);
        this.uploadStatus.setHorizontalAlignment(4);
        this.uploadStatus.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 3));
        this.uploadStatus.setForeground(new Color(220, 220, 220));
        springLayout.putConstraint("North", (Component)this.uploadStatus, 0, "North", (Component)this.getContentPane());
        springLayout.putConstraint("West", (Component)this.uploadStatus, -220, "East", (Component)this.getContentPane());
        springLayout.putConstraint("South", (Component)this.uploadStatus, 160, "North", (Component)this.getContentPane());
        springLayout.putConstraint("East", (Component)this.uploadStatus, 0, "East", (Component)this.getContentPane());
        this.getContentPane().add(this.uploadStatus);
        this.version = new JLabel(this.version_info);
        this.version.setHorizontalAlignment(0);
        this.version.setForeground(Color.WHITE);
        this.version.setFont(this.font);
        this.version.setOpaque(true);
        this.version.setBackground(this.VERSION_BACKGROUND);
        springLayout.putConstraint("North", (Component)this.version, 0, "North", (Component)this.getContentPane());
        springLayout.putConstraint("West", (Component)this.version, -58, "East", (Component)this.getContentPane());
        springLayout.putConstraint("South", (Component)this.version, 21, "North", (Component)this.getContentPane());
        springLayout.putConstraint("East", (Component)this.version, 0, "East", (Component)this.getContentPane());
        this.getContentPane().add(this.version);
        JLabel backgroundImage = new JLabel();
        backgroundImage.setIcon(CoreUtil.getIcon("/newTlauncher.png"));
        springLayout.putConstraint("North", (Component)backgroundImage, 0, "North", (Component)this.getContentPane());
        springLayout.putConstraint("West", (Component)backgroundImage, 0, "West", (Component)this.getContentPane());
        springLayout.putConstraint("South", (Component)backgroundImage, 90, "North", (Component)this.getContentPane());
        springLayout.putConstraint("East", (Component)backgroundImage, 240, "West", (Component)this.getContentPane());
        this.getContentPane().add(backgroundImage);
        this.progressBar = new JProgressBar();
        this.progressBar.setDoubleBuffered(false);
        this.progressBar.setIndeterminate(indeterminate);
        this.progressBar.setBorder(BorderFactory.createEmptyBorder());
        this.progressBar.setUI(new PreloaderProgressUI(CoreUtil.getImage("/bottom-bar.png"), CoreUtil.getImage("/br.png")));
        springLayout.putConstraint("North", (Component)this.progressBar, 0, "South", (Component)backgroundImage);
        springLayout.putConstraint("West", (Component)this.progressBar, 0, "West", (Component)this.getContentPane());
        springLayout.putConstraint("South", (Component)this.progressBar, 0, "South", (Component)this.getContentPane());
        springLayout.putConstraint("East", (Component)this.progressBar, 4, "East", (Component)this.getContentPane());
        this.getContentPane().add(this.progressBar);
        this.pack();
        this.setVisible(true);
    }

    @Subscribe
    public void messageToSpeed(DownloaderStatus status) {
        if (this.progressBar.isIndeterminate() && DownloaderStatusEnum.WORK.equals((Object)status.getDownloaderStatusEnum())) {
            SwingUtilities.invokeLater(() -> {
                this.progressBar.setIndeterminate(false);
                this.updateUploadProgressBar(status);
            });
        } else if (!this.progressBar.isIndeterminate()) {
            SwingUtilities.invokeLater(() -> {
                if (DownloaderStatusEnum.DONE.equals((Object)status.getDownloaderStatusEnum())) {
                    this.progressBar.setIndeterminate(true);
                }
                this.updateUploadProgressBar(status);
            });
        }
    }

    private void updateUploadProgressBar(DownloaderStatus status) {
        int uploaded = (int)status.getDownloadSize() / 0x100000;
        int allUpload = (int)status.getAllDownloadSize() / 0x100000;
        if (!DownloaderStatusEnum.DONE.equals((Object)status.getDownloaderStatusEnum())) {
            this.uploadStatus.setText(String.format("%s %s/%s %s ", this.resourceBundle.getString("uploading"), uploaded, allUpload, this.resourceBundle.getString("mb")));
        } else {
            this.uploadStatus.setText("");
        }
        this.progressBar.setMaximum(allUpload);
        this.progressBar.setValue(uploaded);
    }

    public void setNewVersionText(String versionText) {
        this.version.setText(versionText);
    }

    public class ImagePanel1
    extends JComponent {
        private static final long serialVersionUID = 1L;
        public static final float DEFAULT_ACTIVE_OPACITY = 1.0f;
        public static final float DEFAULT_NON_ACTIVE_OPACITY = 0.75f;
        protected final Object animationLock = new Object();
        private Image originalImage;
        private Image image;
        private boolean antiAlias;
        private boolean shown;
        private boolean animating;

        public ImagePanel1(String image, float activeOpacity, float nonActiveOpacity, boolean shown) {
            this(CoreUtil.getImage(image), activeOpacity, nonActiveOpacity, shown);
        }

        public ImagePanel1(Image image, float activeOpacity, float nonActiveOpacity, boolean shown) {
            this.setImage(image);
            this.setActiveOpacity(activeOpacity);
            this.setNonActiveOpacity(nonActiveOpacity);
            this.shown = shown;
            this.setBackground(new Color(0, 0, 0, 0));
            this.addMouseListenerOriginally(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ImagePanel1.this.onClick();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    ImagePanel1.this.onMouseEntered();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ImagePanel1.this.onMouseExited();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setImage(Image image, boolean resetSize) {
            Object object = this.animationLock;
            synchronized (object) {
                this.originalImage = image;
                this.image = image;
                if (resetSize && image != null) {
                    this.setSize(image.getWidth(null), image.getHeight(null));
                }
            }
        }

        protected void setImage(Image image) {
            this.setImage(image, true);
        }

        protected void setActiveOpacity(float opacity) {
            if (opacity > 1.0f || opacity < 0.0f) {
                throw new IllegalArgumentException("Invalid opacity! Condition: 0.0F <= opacity (got: " + opacity + ") <= 1.0F");
            }
        }

        protected void setNonActiveOpacity(float opacity) {
            if (opacity > 1.0f || opacity < 0.0f) {
                throw new IllegalArgumentException("Invalid opacity! Condition: 0.0F <= opacity (got: " + opacity + ") <= 1.0F");
            }
        }

        protected boolean onClick() {
            return this.shown;
        }

        protected void onMouseEntered() {
            if (this.animating || !this.shown) {
                return;
            }
            this.repaint();
        }

        protected void onMouseExited() {
            if (this.animating || !this.shown) {
                return;
            }
            this.repaint();
        }

        public synchronized void addMouseListenerOriginally(MouseListener listener) {
            super.addMouseListener(listener);
        }

        @Override
        public void paintComponent(Graphics g0) {
            if (this.image == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g0;
            Composite oldComp = g2.getComposite();
            g2.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), null);
            g2.setComposite(oldComp);
        }
    }

    public class ImagePanel
    extends JComponent {
        private static final long serialVersionUID = 1L;
        public static final float DEFAULT_ACTIVE_OPACITY = 1.0f;
        public static final float DEFAULT_NON_ACTIVE_OPACITY = 0.75f;
        protected final Object animationLock = new Object();
        private Image originalImage;
        private Image image;
        private boolean antiAlias;
        private boolean shown;
        private boolean animating;

        public ImagePanel(String image, float activeOpacity, float nonActiveOpacity, boolean shown) {
            this(CoreUtil.getImage(image), activeOpacity, nonActiveOpacity, shown);
        }

        public ImagePanel(Image image, float activeOpacity, float nonActiveOpacity, boolean shown) {
            this.setImage(image);
            this.setActiveOpacity(activeOpacity);
            this.setNonActiveOpacity(nonActiveOpacity);
            this.shown = shown;
            this.setBackground(new Color(0, 0, 0, 0));
            this.addMouseListenerOriginally(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ImagePanel.this.onClick();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    ImagePanel.this.onMouseEntered();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ImagePanel.this.onMouseExited();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setImage(Image image, boolean resetSize) {
            Object object = this.animationLock;
            synchronized (object) {
                this.originalImage = image;
                this.image = image;
                if (resetSize && image != null) {
                    this.setSize(image.getWidth(null), image.getHeight(null));
                }
            }
        }

        protected void setImage(Image image) {
            this.setImage(image, true);
        }

        protected void setActiveOpacity(float opacity) {
            if (opacity > 1.0f || opacity < 0.0f) {
                throw new IllegalArgumentException("Invalid opacity! Condition: 0.0F <= opacity (got: " + opacity + ") <= 1.0F");
            }
        }

        protected void setNonActiveOpacity(float opacity) {
            if (opacity > 1.0f || opacity < 0.0f) {
                throw new IllegalArgumentException("Invalid opacity! Condition: 0.0F <= opacity (got: " + opacity + ") <= 1.0F");
            }
        }

        protected boolean onClick() {
            return this.shown;
        }

        protected void onMouseEntered() {
            if (this.animating || !this.shown) {
                return;
            }
            this.repaint();
        }

        protected void onMouseExited() {
            if (this.animating || !this.shown) {
                return;
            }
            this.repaint();
        }

        public synchronized void addMouseListenerOriginally(MouseListener listener) {
            super.addMouseListener(listener);
        }

        @Override
        public void paintComponent(Graphics g0) {
            if (this.image == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g0;
            Composite oldComp = g2.getComposite();
            g2.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), null);
            g2.setComposite(oldComp);
        }
    }
}

