/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.updater;

import by.gdev.updater.EditorPane;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

class AlertPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int MAX_CHARS = 80;

    AlertPanel(String rawMessage, Object rawTextarea) {
        String message;
        this.setLayout(new BoxLayout(this, 1));
        if (rawMessage == null) {
            message = null;
        } else {
            String b = "<html>" + rawMessage + "</html>";
            message = AlertPanel.wrap(b.toCharArray(), 80, true, false);
        }
        EditorPane label = new EditorPane("text/html", message);
        label.setAlignmentX(0.0f);
        label.setFocusable(false);
        this.add(label);
        if (rawTextarea == null) {
            return;
        }
    }

    public static String wrap(char[] s2, int maxChars, boolean rudeBreaking, boolean detectHTML) {
        if (s2 == null) {
            throw new NullPointerException("sequence");
        }
        if (maxChars < 1) {
            throw new IllegalArgumentException("maxChars < 1");
        }
        detectHTML = detectHTML && AlertPanel.isHTML(s2);
        String lineBreak = detectHTML ? "<br />" : "\n";
        StringBuilder builder = new StringBuilder();
        int len = s2.length;
        int remaining = maxChars;
        boolean tagDetecting = false;
        boolean ignoreCurrent = false;
        for (int x = 0; x < len; ++x) {
            char current = s2[x];
            if (current == '<' && detectHTML) {
                tagDetecting = true;
                ignoreCurrent = true;
            } else if (tagDetecting) {
                if (current == '>') {
                    tagDetecting = false;
                }
                ignoreCurrent = true;
            }
            if (ignoreCurrent) {
                ignoreCurrent = false;
                builder.append(current);
                continue;
            }
            if (s2[x] == '\n' || --remaining < 1 && current == ' ') {
                remaining = maxChars;
                builder.append(lineBreak);
                continue;
            }
            if (AlertPanel.lookForward(s2, x, lineBreak)) {
                remaining = maxChars;
            }
            builder.append(current);
            if (remaining > 0 || !rudeBreaking) continue;
            remaining = maxChars;
            builder.append(lineBreak);
        }
        return builder.toString();
    }

    public static boolean isHTML(char[] s2) {
        if (s2 != null && s2.length >= 6 && s2[0] == '<' && s2[5] == '>') {
            String tag = new String(s2, 1, 4);
            return tag.equalsIgnoreCase("html");
        }
        return false;
    }

    private static boolean lookForward(char[] c, int caret, CharSequence search) {
        int available;
        if (c == null) {
            throw new NullPointerException("char array");
        }
        if (caret < 0) {
            throw new IllegalArgumentException("caret < 0");
        }
        if (caret >= c.length) {
            return false;
        }
        int length = search.length();
        if (length < (available = c.length - caret)) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (c[caret + i] == search.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

