/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.ui.subscriber;

import by.gdev.Main;
import by.gdev.http.download.exeption.HashSumAndSizeError;
import by.gdev.http.download.exeption.UploadFileException;
import by.gdev.http.upload.download.downloader.DownloaderStatus;
import by.gdev.http.upload.download.downloader.DownloaderStatusEnum;
import by.gdev.model.ExceptionMessage;
import by.gdev.model.LogResponse;
import by.gdev.model.StarterAppConfig;
import by.gdev.model.StarterAppProcess;
import by.gdev.updater.ProgressFrame;
import by.gdev.util.CoreUtil;
import by.gdev.util.DesktopUtil;
import by.gdev.util.OSInfo;
import com.google.common.eventbus.Subscribe;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.zip.GZIPOutputStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewSubscriber {
    private static final Logger log = LoggerFactory.getLogger(ViewSubscriber.class);
    private ProgressFrame frame;
    private ResourceBundle bundle;
    private OSInfo.OSType osType;
    private StarterAppConfig starterConfig;

    @Subscribe
    private void procces(StarterAppProcess status) {
        if (!StringUtils.isEmpty(status.getLine()) && status.getLine().equals("java.lang.UnsatisfiedLinkError: no zip in java.library.path")) {
            this.message(new ExceptionMessage(String.format(this.bundle.getString("unsatisfied.link.error"), Paths.get(this.starterConfig.getWorkDirectory(), new String[0]).toAbsolutePath().toString(), "C:\\" + this.starterConfig.getWorkDirectory())));
        }
        if (Objects.nonNull(status.getErrorCode())) {
            if (status.getErrorCode() == -1073740791) {
                this.message(new ExceptionMessage(this.bundle.getString("driver.error"), String.format("https://tlauncher.org/%s/closed-minecraft-1073740791.html", this.bundle.getLocale().getLanguage())));
            } else if (status.getErrorCode() == -1073740771) {
                this.message(new ExceptionMessage(this.bundle.getString("msi.afterburner.error")));
            } else if (status.getErrorCode() != 0) {
                String s1 = Objects.nonNull(this.starterConfig.getLogURIService()) ? "unidentified.error" : "unidentified.error.1";
                ExceptionMessage e = new ExceptionMessage(this.bundle.getString(s1));
                e.setLogButton(true);
                this.message(e);
                System.exit(0);
            }
        }
    }

    @Subscribe
    public void message(DownloaderStatus status) {
        if (DownloaderStatusEnum.DONE.equals((Object)status.getDownloaderStatusEnum()) && !status.getThrowables().isEmpty()) {
            Throwable t = status.getThrowables().get(0);
            if (t instanceof HashSumAndSizeError) {
                HashSumAndSizeError t1 = (HashSumAndSizeError)t;
                String s2 = String.format(this.bundle.getString("upload.error.hash.sum"), t1.getUri(), t1.getMessage());
                this.message(new ExceptionMessage(s2, t1.getUri()));
            } else if (t instanceof UploadFileException) {
                this.message(new ExceptionMessage(this.bundle.getString("net.problem")));
            }
        }
    }

    @Subscribe
    public void message(final ExceptionMessage s2) {
        JTextPane f = this.getTextPaneWithMessage(s2);
        JPanel p = new JPanel();
        BoxLayout bl = new BoxLayout(p, 1);
        p.setLayout(bl);
        p.add((Component)f, "Center");
        if (s2.isLogButton() && Objects.nonNull(this.starterConfig.getLogURIService())) {
            this.addLogOffer(p);
        }
        if (Objects.nonNull(s2.getLink())) {
            f.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        DesktopUtil.openLink(ViewSubscriber.this.osType, s2.getLink());
                    }
                }
            });
        }
        JOptionPane.showMessageDialog(this.frame, p, "", 0);
    }

    protected void addLogOffer(JPanel p) {
        JPanel p1 = new JPanel();
        JButton b = new JButton(this.bundle.getString("link.get"));
        JLabel l = new JLabel(this.bundle.getString("preparing"));
        JTextPane tp = this.getTextPaneWithMessage(new ExceptionMessage(""));
        p1.add(b);
        p1.add(l);
        p1.add(tp);
        tp.setVisible(false);
        l.setVisible(false);
        b.addActionListener(e -> {
            b.setVisible(false);
            l.setVisible(true);
            this.doRequest(p1, l, tp);
        });
        tp.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        p.add((Component)p1, "South");
    }

    private void doRequest(JPanel p, JLabel l, JTextPane tp) {
        CompletableFuture.runAsync(() -> {
            Exception e2 = null;
            Pair<String, byte[]> pair = null;
            for (String s2 : this.starterConfig.getLogURIService()) {
                HttpPost method = new HttpPost(s2);
                HttpResponse response = null;
                try {
                    pair = CoreUtil.readFileLog();
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    GZIPOutputStream g2 = new GZIPOutputStream(out);
                    g2.write(pair.getValue());
                    g2.close();
                    byte[] body = out.toByteArray();
                    method.setEntity(new ByteArrayEntity(body));
                    method.setConfig(RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(60000).build());
                    response = Main.client.execute(method);
                    if (response.getStatusLine().getStatusCode() >= 300) {
                        log.info("not proper code " + response.getStatusLine().toString());
                        this.showError(p, pair);
                    } else {
                        LogResponse lr = Main.GSON.fromJson(IOUtils.toString(response.getEntity().getContent(), StandardCharsets.UTF_8), LogResponse.class);
                        SwingUtilities.invokeLater(() -> {
                            tp.setText(String.format("<html>%s</html>", lr.getLink()));
                            StringSelection selection = new StringSelection(lr.getLink());
                            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                            clipboard.setContents(selection, selection);
                            l.setVisible(false);
                            tp.setVisible(true);
                            JOptionPane.showMessageDialog(this.frame, this.bundle.getString("clipboard.copy"), "", 1);
                        });
                    }
                    return;
                }
                catch (Exception e1) {
                    e2 = e1;
                }
                finally {
                    if (!Objects.nonNull(response)) continue;
                    method.abort();
                    EntityUtils.consumeQuietly(response.getEntity());
                }
            }
            log.error("exception", e2);
            this.showError(p, pair);
        });
    }

    private void showError(JPanel p, Pair<String, byte[]> pair) {
        JTextPane tp = this.getTextPaneWithMessage(new ExceptionMessage(String.format(this.bundle.getString("error.log.send"), Objects.isNull(pair) ? "" : pair.getKey()), ""));
        p.setVisible(false);
        JOptionPane.showMessageDialog(this.frame, tp, null, 0);
    }

    protected JTextPane getTextPaneWithMessage(ExceptionMessage s2) {
        JTextPane f = new JTextPane();
        f.setContentType("text/html");
        f.setText(String.format("<html>%s</html>", s2.getMessage() + (Objects.nonNull(s2.getError()) ? "<br> <br>" + ExceptionUtils.getStackTrace(s2.getError()).replaceAll("\n", "<br>") : "")));
        f.setEditable(false);
        f.setBackground(null);
        f.setBorder(null);
        return f;
    }

    public ViewSubscriber(ProgressFrame frame, ResourceBundle bundle, OSInfo.OSType osType, StarterAppConfig starterConfig) {
        this.frame = frame;
        this.bundle = bundle;
        this.osType = osType;
        this.starterConfig = starterConfig;
    }
}

