/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.ui;

import by.gdev.model.AppConfig;
import by.gdev.model.AppLocalConfig;
import by.gdev.model.StarterAppConfig;
import by.gdev.ui.JLabelHtmlWrapper;
import by.gdev.util.DesktopUtil;
import by.gdev.util.OSInfo;
import by.gdev.utils.service.FileMapperService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateFrame
extends JFrame {
    private static final Logger log = LoggerFactory.getLogger(UpdateFrame.class);
    private static final long serialVersionUID = 2832387031191814036L;
    private AtomicInteger userChoose = new AtomicInteger();

    public UpdateFrame(JFrame progressFrame, ResourceBundle resourceBundle, AppLocalConfig appLocalConfig, AppConfig remoteAppConfig, StarterAppConfig starterAppConfig, FileMapperService fileMapperService, final OSInfo.OSType osType) {
        progressFrame.setVisible(false);
        this.setResizable(false);
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        int width = gd.getDisplayMode().getWidth();
        int height = gd.getDisplayMode().getHeight();
        this.setSize(new Dimension(width / 4, height / 5));
        this.setLocation(width / 2 - this.getSize().width / 2, height / 2 - this.getSize().height / 2);
        progressFrame.setVisible(false);
        JPanel p = new JPanel(new BorderLayout(0, 0));
        p.setBackground(new Color(215, 215, 215));
        p.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        final String link = starterAppConfig.getServerFile().get(0) + "changes.log";
        final JLabelHtmlWrapper text = new JLabelHtmlWrapper(String.format(resourceBundle.getString("update.app"), appLocalConfig.getCurrentAppVersion(), remoteAppConfig.getAppVersion()));
        text.setFont(text.getFont().deriveFont(1));
        text.setHorizontalAlignment(0);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JPanel verticalPanel = new JPanel();
        verticalPanel.setOpaque(false);
        BoxLayout boxLayout = new BoxLayout(verticalPanel, 1);
        verticalPanel.setLayout(boxLayout);
        this.addButton(new JButton(resourceBundle.getString("skip")), buttonPanel, 1);
        this.addButton(new JButton(resourceBundle.getString("update")), buttonPanel, 2);
        this.setDefaultCloseOperation(3);
        verticalPanel.add(buttonPanel);
        JCheckBox j = new JCheckBox(String.format(resourceBundle.getString("not.show.again"), remoteAppConfig.getAppVersion()));
        j.setAlignmentX(0.5f);
        j.addActionListener(e -> {
            try {
                AppLocalConfig app = fileMapperService.read("starter.json", AppLocalConfig.class);
                app.setSkipUpdateVersion(remoteAppConfig.getAppVersion());
                fileMapperService.write(app, "starter.json");
            }
            catch (IOException e1) {
                log.error("error", e1);
            }
        });
        text.addMouseListener(new MouseAdapter(){
            private Color c;
            {
                this.c = text.getForeground();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    DesktopUtil.openLink(osType, link);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                text.setForeground(Color.BLACK);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                text.setForeground(this.c);
            }
        });
        verticalPanel.add((Component)j, "Center");
        buttonPanel.setOpaque(false);
        p.add((Component)text, "Center");
        p.add((Component)verticalPanel, "South");
        this.add(p);
        this.pack();
        this.setVisible(true);
        while (this.isVisible()) {
            DesktopUtil.sleep(100);
        }
        progressFrame.setVisible(true);
    }

    private void addButton(JButton b, JPanel panel, int code) {
        b.setAlignmentX(0.5f);
        b.addActionListener(e -> {
            this.userChoose.set(code);
            this.setVisible(false);
        });
        panel.add(b);
    }

    public int getUserChoose() {
        return this.userChoose.get();
    }
}

