/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.subscruber;

import by.gdev.http.upload.download.downloader.DownloadFile;
import by.gdev.http.upload.download.downloader.DownloaderStatus;
import by.gdev.http.upload.download.downloader.DownloaderStatusEnum;
import by.gdev.model.AppLocalConfig;
import by.gdev.model.ExceptionMessage;
import by.gdev.model.StarterAppConfig;
import by.gdev.model.StarterAppProcess;
import by.gdev.updater.ProgressFrame;
import by.gdev.util.DesktopUtil;
import by.gdev.utils.service.FileMapperService;
import com.google.common.eventbus.Subscribe;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleSubscriber {
    private static final Logger log = LoggerFactory.getLogger(ConsoleSubscriber.class);
    private ResourceBundle bundle;
    private FileMapperService fileMapperService;
    private StarterAppConfig starterConfig;
    private AppLocalConfig appLocalConfig;
    private ProgressFrame starterStatusFrame;

    @Subscribe
    public void downloadStatusMessage(DownloaderStatus status) {
        if (!status.getDownloaderStatusEnum().equals((Object)DownloaderStatusEnum.IDLE) && status.getLeftFiles() != 0) {
            log.info(String.format(this.bundle.getString("upload.speed"), String.format("%.1f", status.getSpeed()), status.getLeftFiles(), status.getAllFiles(), status.getDownloadSize() / 0x100000L, status.getAllDownloadSize() / 0x100000L));
        }
        if (status.getDownloaderStatusEnum().equals((Object)DownloaderStatusEnum.DONE) && status.getThrowables().size() != 0) {
            log.error("error", status.getThrowables().get(0));
            System.exit(-1);
        }
    }

    @Subscribe
    private void procces(StarterAppProcess status) {
        this.checkUnsatisfiedLinkError(status);
        if (Objects.nonNull(status.getErrorCode())) {
            if (status.getErrorCode() == -1073740791) {
                log.error(this.bundle.getString("driver.error"));
            } else if (status.getErrorCode() == -1073740771) {
                log.error(this.bundle.getString("msi.afterburner.error"));
            } else if (status.getErrorCode() != 0) {
                log.error(this.bundle.getString("unidentified.error"));
                System.exit(0);
            }
        } else if (status.getLine().contains("starter can be closed")) {
            while (Objects.nonNull(this.appLocalConfig) && this.appLocalConfig.isExecuteOffer()) {
                this.starterStatusFrame.setVisible(false);
                DesktopUtil.sleep(3000);
            }
            System.exit(0);
        } else {
            log.info(status.getLine());
        }
    }

    @Subscribe
    public void validateMessage(ExceptionMessage message) {
        log.error(message.printValidationMessage());
        System.exit(-1);
    }

    @Subscribe
    public void downloadedFile(DownloadFile entity) {
        log.info("downloaded file: {} -> {} size {}", entity.getUri(), entity.getFile(), entity.getSize());
    }

    private void checkUnsatisfiedLinkError(StarterAppProcess status) {
        if (!StringUtils.isEmpty(status.getLine()) && status.getLine().equals("java.lang.UnsatisfiedLinkError: no zip in java.library.path")) {
            String newWorkDir = "C:\\" + this.starterConfig.getWorkDirectory();
            log.error(String.format(this.bundle.getString("unidentified.error"), Paths.get(this.starterConfig.getWorkDirectory(), new String[0]).toAbsolutePath().toString(), newWorkDir));
        }
    }

    public ConsoleSubscriber(ResourceBundle bundle, FileMapperService fileMapperService, StarterAppConfig starterConfig, AppLocalConfig appLocalConfig, ProgressFrame starterStatusFrame) {
        this.bundle = bundle;
        this.fileMapperService = fileMapperService;
        this.starterConfig = starterConfig;
        this.appLocalConfig = appLocalConfig;
        this.starterStatusFrame = starterStatusFrame;
    }
}

