/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.process;

import by.gdev.process.ProcessMonitor;
import by.gdev.util.model.download.Repo;
import com.google.common.eventbus.EventBus;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaProcessHelper {
    private static final Logger log = LoggerFactory.getLogger(JavaProcessHelper.class);
    private final String jvmPath;
    private final List<String> commands;
    private File directory;
    private ProcessBuilder process;
    private EventBus listener;
    ProcessMonitor monitor;

    public JavaProcessHelper(String jvmPath, File directory, EventBus listener) {
        this.jvmPath = jvmPath;
        this.directory = directory;
        this.listener = listener;
        this.commands = new ArrayList<String>();
    }

    public void start() throws IOException {
        this.monitor = new ProcessMonitor(this.createProcess().start(), this.listener);
        this.monitor.start();
    }

    public void destroyProcess() {
        this.monitor.getProcess().destroyForcibly();
    }

    public ProcessBuilder createProcess() {
        String javaOption;
        if (Objects.isNull(this.process)) {
            this.process = new ProcessBuilder(this.getFullCommands()).directory(this.directory).redirectErrorStream(true);
        }
        if (Objects.nonNull(javaOption = JavaProcessHelper.findJavaOptionAndGetName())) {
            this.process.environment().put(javaOption, "");
        }
        String runCommand = this.process.command().stream().collect(Collectors.joining(" "));
        log.info("start command {}", (Object)runCommand);
        return this.process;
    }

    private List<String> getFullCommands() {
        ArrayList<String> result = new ArrayList<String>(this.commands);
        result.add(0, this.jvmPath);
        return result;
    }

    private static String findJavaOptionAndGetName() {
        for (Map.Entry<String, String> e : System.getenv().entrySet()) {
            if (!e.getKey().equalsIgnoreCase("_java_options")) continue;
            return e.getKey();
        }
        return null;
    }

    public void addCommand(String command) {
        this.commands.add(command);
    }

    public void addCommand(String key, String value) {
        this.commands.add(key);
        this.commands.add(value);
    }

    public void addCommands(List<String> list) {
        for (String c : list) {
            this.commands.add(c);
        }
    }

    public List<Path> librariesForRunning(String workDirectory, Repo fileRepo, Repo dependencis) {
        ArrayList<Path> list = new ArrayList<Path>();
        dependencis.getResources().forEach(dep -> list.add(Paths.get(workDirectory, dep.getPath())));
        fileRepo.getResources().forEach(core -> list.add(Paths.get(workDirectory, core.getPath())));
        return list;
    }

    public String getJvmPath() {
        return this.jvmPath;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public File getDirectory() {
        return this.directory;
    }

    public ProcessBuilder getProcess() {
        return this.process;
    }

    public EventBus getListener() {
        return this.listener;
    }

    public ProcessMonitor getMonitor() {
        return this.monitor;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public void setProcess(ProcessBuilder process) {
        this.process = process;
    }

    public void setListener(EventBus listener) {
        this.listener = listener;
    }

    public void setMonitor(ProcessMonitor monitor) {
        this.monitor = monitor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaProcessHelper)) {
            return false;
        }
        JavaProcessHelper other = (JavaProcessHelper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$jvmPath = this.getJvmPath();
        String other$jvmPath = other.getJvmPath();
        if (this$jvmPath == null ? other$jvmPath != null : !this$jvmPath.equals(other$jvmPath)) {
            return false;
        }
        List<String> this$commands = this.getCommands();
        List<String> other$commands = other.getCommands();
        if (this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands)) {
            return false;
        }
        File this$directory = this.getDirectory();
        File other$directory = other.getDirectory();
        if (this$directory == null ? other$directory != null : !((Object)this$directory).equals(other$directory)) {
            return false;
        }
        ProcessBuilder this$process = this.getProcess();
        ProcessBuilder other$process = other.getProcess();
        if (this$process == null ? other$process != null : !this$process.equals(other$process)) {
            return false;
        }
        EventBus this$listener = this.getListener();
        EventBus other$listener = other.getListener();
        if (this$listener == null ? other$listener != null : !this$listener.equals(other$listener)) {
            return false;
        }
        ProcessMonitor this$monitor = this.getMonitor();
        ProcessMonitor other$monitor = other.getMonitor();
        return !(this$monitor == null ? other$monitor != null : !this$monitor.equals(other$monitor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JavaProcessHelper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $jvmPath = this.getJvmPath();
        result = result * 59 + ($jvmPath == null ? 43 : $jvmPath.hashCode());
        List<String> $commands = this.getCommands();
        result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
        File $directory = this.getDirectory();
        result = result * 59 + ($directory == null ? 43 : ((Object)$directory).hashCode());
        ProcessBuilder $process = this.getProcess();
        result = result * 59 + ($process == null ? 43 : $process.hashCode());
        EventBus $listener = this.getListener();
        result = result * 59 + ($listener == null ? 43 : $listener.hashCode());
        ProcessMonitor $monitor = this.getMonitor();
        result = result * 59 + ($monitor == null ? 43 : $monitor.hashCode());
        return result;
    }

    public String toString() {
        return "JavaProcessHelper(jvmPath=" + this.getJvmPath() + ", commands=" + this.getCommands() + ", directory=" + this.getDirectory() + ", process=" + this.getProcess() + ", listener=" + this.getListener() + ", monitor=" + this.getMonitor() + ")";
    }
}

