/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.http.download.handler;

import by.gdev.http.download.handler.PostHandler;
import by.gdev.http.upload.download.downloader.DownloadElement;
import by.gdev.http.upload.download.downloader.DownloaderJavaContainer;
import by.gdev.util.DesktopUtil;
import by.gdev.util.OSInfo;
import by.gdev.util.model.download.JvmRepo;
import by.gdev.util.model.download.Metadata;
import by.gdev.util.model.download.Repo;
import by.gdev.utils.service.FileMapperService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveHandler
implements PostHandler {
    private static final Logger log = LoggerFactory.getLogger(ArchiveHandler.class);
    private FileMapperService fileMapperService;
    private String jreConfig;

    @Override
    public void postProcessDownloadElement(DownloadElement e) throws IOException, NoSuchAlgorithmException {
        Path p = Paths.get(e.getPathToDownload(), e.getMetadata().getPath());
        String jrePath = Paths.get(DownloaderJavaContainer.JRE_DEFAULT, ((JvmRepo)e.getRepo()).getJreDirectoryName()).toString();
        if (String.valueOf(p).endsWith(".zip")) {
            this.unZip(p.toFile(), new File(e.getPathToDownload()), false, false);
        } else {
            this.unTarGz(p.toFile(), new File(e.getPathToDownload()), false, false);
        }
        if (OSInfo.getOSType() == OSInfo.OSType.LINUX | OSInfo.getOSType() == OSInfo.OSType.MACOSX) {
            Files.walk(Paths.get(e.getPathToDownload(), jrePath), new FileVisitOption[0]).filter(f -> Files.isRegularFile(f, new LinkOption[0]) && (f.endsWith("java") || f.endsWith("java.exe") || f.endsWith("jspawnhelper") || f.endsWith("jspawnhelper.exe"))).forEach(file -> {
                try {
                    Files.setPosixFilePermissions(file, DesktopUtil.PERMISSIONS);
                }
                catch (IOException e1) {
                    log.error("Error with set file permissions ", e1);
                }
            });
        }
        this.generateJreConfig(e.getPathToDownload(), jrePath);
        Files.delete(p);
    }

    private void createFile(File file) throws IOException {
        if (file.isFile()) {
            return;
        }
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        if (!file.createNewFile()) {
            throw new IOException("Cannot createScrollWrapper file, or it was created during runtime: " + file.getAbsolutePath());
        }
    }

    private void unTarGz(File zip, File folder, boolean replace, boolean deleteEmptyFile) throws IOException, NoSuchAlgorithmException {
        try (TarArchiveInputStream zis = new TarArchiveInputStream(new GzipCompressorInputStream(new BufferedInputStream(new FileInputStream(zip))));){
            TarArchiveEntry ze;
            while ((ze = (TarArchiveEntry)zis.getNextEntry()) != null) {
                String fileName = Paths.get(DownloaderJavaContainer.JRE_DEFAULT, ze.getName()).toString();
                if (ze.isDirectory()) continue;
                this.unZipAndTarGz(fileName, folder, replace, zis, deleteEmptyFile);
            }
            zis.close();
        }
    }

    private void unZip(File zip, File folder, boolean replace, boolean deleteEmptyFile) throws IOException, NoSuchAlgorithmException {
        try (ZipInputStream zis = new ZipInputStream((InputStream)new BufferedInputStream(new FileInputStream(zip)), StandardCharsets.UTF_8);){
            ZipEntry ze;
            while ((ze = zis.getNextEntry()) != null) {
                String fileName = Paths.get(DownloaderJavaContainer.JRE_DEFAULT, ze.getName()).toString();
                if (ze.isDirectory()) continue;
                this.unZipAndTarGz(fileName, folder, replace, zis, deleteEmptyFile);
            }
            zis.closeEntry();
        }
    }

    private void unZipAndTarGz(String fileName, File folder, boolean replace, InputStream zis, boolean deleteEmptyFile) throws IOException, NoSuchAlgorithmException {
        int len;
        byte[] buffer = new byte[1024];
        File newFile = new File(folder, fileName);
        if (!replace && newFile.isFile()) {
            return;
        }
        this.createFile(newFile);
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(newFile));
        int count = 0;
        while ((len = zis.read(buffer)) > 0) {
            count += len;
            ((OutputStream)fos).write(buffer, 0, len);
        }
        ((OutputStream)fos).close();
        if (deleteEmptyFile && count == 0) {
            Files.delete(newFile.toPath());
        }
    }

    private void generateJreConfig(String path, String jrePath) {
        try {
            List<Metadata> list = DesktopUtil.generateMetadataForJre(path, jrePath);
            Repo r = new Repo();
            r.setResources(list);
            this.fileMapperService.write(r, Paths.get(jrePath, this.jreConfig).toString());
        }
        catch (Exception e) {
            log.error("error {}", e);
        }
    }

    public FileMapperService getFileMapperService() {
        return this.fileMapperService;
    }

    public String getJreConfig() {
        return this.jreConfig;
    }

    public void setFileMapperService(FileMapperService fileMapperService) {
        this.fileMapperService = fileMapperService;
    }

    public void setJreConfig(String jreConfig) {
        this.jreConfig = jreConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArchiveHandler)) {
            return false;
        }
        ArchiveHandler other = (ArchiveHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FileMapperService this$fileMapperService = this.getFileMapperService();
        FileMapperService other$fileMapperService = other.getFileMapperService();
        if (this$fileMapperService == null ? other$fileMapperService != null : !this$fileMapperService.equals(other$fileMapperService)) {
            return false;
        }
        String this$jreConfig = this.getJreConfig();
        String other$jreConfig = other.getJreConfig();
        return !(this$jreConfig == null ? other$jreConfig != null : !this$jreConfig.equals(other$jreConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ArchiveHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FileMapperService $fileMapperService = this.getFileMapperService();
        result = result * 59 + ($fileMapperService == null ? 43 : $fileMapperService.hashCode());
        String $jreConfig = this.getJreConfig();
        result = result * 59 + ($jreConfig == null ? 43 : $jreConfig.hashCode());
        return result;
    }

    public String toString() {
        return "ArchiveHandler(fileMapperService=" + this.getFileMapperService() + ", jreConfig=" + this.getJreConfig() + ")";
    }

    public ArchiveHandler(FileMapperService fileMapperService, String jreConfig) {
        this.fileMapperService = fileMapperService;
        this.jreConfig = jreConfig;
    }
}

