/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.handler;

import by.gdev.handler.ValidateEnvironment;
import by.gdev.model.ExceptionMessage;
import by.gdev.util.OSInfo;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X32Interceptor
implements ValidateEnvironment {
    private static final Logger log = LoggerFactory.getLogger(X32Interceptor.class);
    private ResourceBundle bundle;

    @Override
    public boolean validate() {
        if (OSInfo.getOSType().equals((Object)OSInfo.OSType.WINDOWS)) {
            String curArch = System.getProperty("sun.arch.data.model");
            log.info("sun.arch.data.model {}", (Object)curArch);
            for (OSInfo.Arch arch : OSInfo.Arch.values()) {
                if (!arch.toString().contains(curArch) || !arch.equals((Object)OSInfo.Arch.x32)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public ExceptionMessage getExceptionMessage() {
        return new ExceptionMessage(String.format(this.bundle.getString("validate.x32"), new Object[0]), "https://tlauncher.org");
    }

    public X32Interceptor(ResourceBundle bundle) {
        this.bundle = bundle;
    }
}

