/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.handler;

import by.gdev.Main;
import by.gdev.http.download.exeption.HashSumAndSizeError;
import by.gdev.http.download.service.FileCacheService;
import by.gdev.http.download.service.GsonService;
import by.gdev.model.StarterAppConfig;
import by.gdev.model.UpdateApp;
import by.gdev.ui.JLabelHtmlWrapper;
import by.gdev.util.DesktopUtil;
import by.gdev.util.DesktopUtilZone;
import by.gdev.util.InternetServerMap;
import by.gdev.util.OSInfo;
import by.gdev.util.model.download.Metadata;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCore {
    private static final Logger log = LoggerFactory.getLogger(UpdateCore.class);
    private ResourceBundle bundle;
    private GsonService gsonService;
    private FileCacheService fileCacheService;
    private StarterAppConfig starterConfig;
    private InternetServerMap domainAvailability;
    private String country;

    public void checkUpdates(OSInfo.OSType osType) throws IOException, NoSuchAlgorithmException {
        UpdateApp ua = this.getUpdateFile();
        File jarFile = new File(URLDecoder.decode(Main.class.getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8"));
        if (jarFile.toString().endsWith("classes")) {
            return;
        }
        String key = osType.name() + (jarFile.toString().endsWith("exe") ? "exe" : "");
        if (ua == null || ua.getMap() == null || !ua.getMap().containsKey(key) || !ua.getMap().containsKey(key)) {
            return;
        }
        Metadata m3 = ua.getMap().get(key);
        String localeSha1 = DesktopUtil.getChecksum(jarFile, "SHA-1");
        if (!m3.getSha1().equals(localeSha1)) {
            Path temp = this.fileCacheService.getRawObject(DesktopUtilZone.removeRuZoneFromOther(this.country, ua.getUrls()), m3, false);
            JLabelHtmlWrapper label = new JLabelHtmlWrapper(this.bundle.getString("update.message"));
            JOptionPane.showMessageDialog(new JFrame(), label, "", 1);
            String hash = DesktopUtil.getChecksum(temp.toFile(), "SHA-1");
            if (!hash.equals(m3.getSha1())) {
                throw new HashSumAndSizeError(ua.getUrls().toString(), m3.toString() + " " + hash, "");
            }
            log.info("from {} to {}", (Object)temp.toString(), (Object)jarFile.toPath().toString());
            try (FileOutputStream outputStream = new FileOutputStream(jarFile);){
                IOUtils.copy((InputStream)new FileInputStream(temp.toFile()), (OutputStream)outputStream);
            }
            System.exit(0);
        }
    }

    private UpdateApp getUpdateFile() throws IOException {
        if (this.domainAvailability.hasInternetForDomains(this.starterConfig.getServerFile())) {
            return this.gsonService.getObjectWithoutSaving(this.starterConfig.getServerFile(), "starterUpdateV1.json", UpdateApp.class);
        }
        return null;
    }

    public UpdateCore(ResourceBundle bundle, GsonService gsonService, FileCacheService fileCacheService, StarterAppConfig starterConfig, InternetServerMap domainAvailability, String country) {
        this.bundle = bundle;
        this.gsonService = gsonService;
        this.fileCacheService = fileCacheService;
        this.starterConfig = starterConfig;
        this.domainAvailability = domainAvailability;
        this.country = country;
    }
}

