/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.component;

import by.gdev.Main;
import by.gdev.handler.UpdateCore;
import by.gdev.handler.ValidateEnvironment;
import by.gdev.handler.ValidateFont;
import by.gdev.handler.ValidateTempDir;
import by.gdev.handler.ValidateTempNull;
import by.gdev.handler.ValidateUpdate;
import by.gdev.handler.ValidateWorkDir;
import by.gdev.handler.ValidatedPartionSize;
import by.gdev.http.download.exeption.HashSumAndSizeError;
import by.gdev.http.download.handler.ArchiveHandler;
import by.gdev.http.download.handler.PostHandlerImpl;
import by.gdev.http.download.impl.DownloaderImpl;
import by.gdev.http.download.impl.FileCacheServiceImpl;
import by.gdev.http.download.impl.GsonServiceImpl;
import by.gdev.http.download.impl.HttpServiceImpl;
import by.gdev.http.download.service.GsonService;
import by.gdev.http.upload.download.downloader.DownloaderContainer;
import by.gdev.http.upload.download.downloader.DownloaderJavaContainer;
import by.gdev.model.AppConfig;
import by.gdev.model.AppLocalConfig;
import by.gdev.model.ExceptionMessage;
import by.gdev.model.JVMConfig;
import by.gdev.model.StarterAppConfig;
import by.gdev.process.JavaProcessHelper;
import by.gdev.updater.ProgressFrame;
import by.gdev.updater.Update;
import by.gdev.updater.UpdaterFormController;
import by.gdev.util.DesktopUtil;
import by.gdev.util.DesktopUtilZone;
import by.gdev.util.InternetServerMap;
import by.gdev.util.OSInfo;
import by.gdev.util.StringVersionComparator;
import by.gdev.util.model.download.JvmRepo;
import by.gdev.util.model.download.Repo;
import by.gdev.utils.service.FileMapperService;
import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.apache.commons.text.StringSubstitutor;
import org.apache.http.client.config.RequestConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Starter {
    private static final Logger log = LoggerFactory.getLogger(Starter.class);
    private EventBus eventBus;
    private StarterAppConfig starterConfig;
    private OSInfo.OSType osType = OSInfo.getOSType();
    private OSInfo.Arch osArc = OSInfo.getJavaBit();
    private AppConfig remoteAppConfig;
    private AppConfig remoteAppConfigDefault;
    private JVMConfig jvm;
    private Repo dependencis;
    private ProgressFrame starterStatusFrame;
    private ResourceBundle bundle;
    private GsonService gsonService;
    private RequestConfig requestConfig;
    private FileMapperService fileMapperService;
    private String workDir;
    private UpdateCore updateCore;
    private AppLocalConfig appLocalConfig;
    private JvmRepo java;
    private InternetServerMap domainAvailability;
    private String country;

    public Starter(EventBus eventBus, StarterAppConfig starterConfig, ResourceBundle bundle, ProgressFrame starterStatusFrame, AppLocalConfig appLocalConfig, FileMapperService fileMapperService, String country) throws UnsupportedOperationException, IOException, InterruptedException {
        this.eventBus = eventBus;
        this.appLocalConfig = appLocalConfig;
        this.starterStatusFrame = starterStatusFrame;
        this.bundle = bundle;
        this.starterConfig = starterConfig;
        this.fileMapperService = fileMapperService;
        this.country = country;
        this.domainAvailability = DesktopUtil.testServers(starterConfig.getTestURLs(), Main.client);
        this.domainAvailability.setAvailableInternet(this.domainAvailability.hasInternet());
        log.trace("Max attempts from download = {}", (Object)starterConfig.getMaxAttempts());
        HttpServiceImpl httpService = new HttpServiceImpl(null, Main.client, starterConfig.getMaxAttempts());
        FileCacheServiceImpl fileService = new FileCacheServiceImpl(httpService, Main.GSON, Main.charset, Paths.get(starterConfig.getWorkDirectory(), "cache"), starterConfig.getTimeToLife(), this.domainAvailability);
        this.gsonService = new GsonServiceImpl(Main.GSON, fileService, httpService, this.domainAvailability);
        this.updateCore = new UpdateCore(bundle, this.gsonService, fileService, starterConfig, this.domainAvailability, country);
        this.workDir = starterConfig.getWorkDirectory();
    }

    public void validateEnvironmentAndAppRequirements() throws Exception {
        ArrayList<ValidateEnvironment> validateEnvironment = new ArrayList<ValidateEnvironment>();
        validateEnvironment.add(new ValidatedPartionSize(this.starterConfig.getMinMemorySize(), new File(this.workDir), this.bundle));
        validateEnvironment.add(new ValidateWorkDir(this.workDir, this.bundle));
        validateEnvironment.add(new ValidateTempNull(this.bundle));
        validateEnvironment.add(new ValidateTempDir(this.bundle));
        validateEnvironment.add(new ValidateFont(this.bundle));
        validateEnvironment.add(new ValidateUpdate(this.bundle));
        for (ValidateEnvironment val : validateEnvironment) {
            if (!val.validate()) {
                log.error(this.bundle.getString("validate.error") + " " + val.getClass().getName());
                this.eventBus.post(val.getExceptionMessage());
                continue;
            }
            log.debug(this.bundle.getString("validate.successful") + " " + val.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareResources() throws Exception {
        log.info("Start loading");
        log.info(String.valueOf((Object)this.osType));
        log.info(String.valueOf((Object)this.osArc));
        try {
            Repo resources;
            DesktopUtil.activeDoubleDownloadingResourcesLock(this.workDir);
            DownloaderImpl downloader = new DownloaderImpl(this.eventBus, Main.client, this.requestConfig, this.domainAvailability, false);
            DownloaderContainer container = new DownloaderContainer();
            String serverFileUrn = this.starterConfig.getServerFileConfig(this.starterConfig, this.starterConfig.getVersion());
            if (this.domainAvailability.hasInternetForDomains(this.starterConfig.getServerFile())) {
                log.info("app remote config: {}", (Object)this.starterConfig.getServerFile());
                this.remoteAppConfigDefault = this.remoteAppConfig = this.gsonService.getObjectByUrls(this.starterConfig.getServerFile(), serverFileUrn, AppConfig.class, false);
                this.updateApp(this.gsonService, this.fileMapperService);
                Repo rd = this.remoteAppConfig.getAppDependencies();
                rd.setRepositories(DesktopUtilZone.removeRuZoneFromOther(this.country, rd.getRepositories()));
                this.dependencis = this.gsonService.getObjectByUrls(this.remoteAppConfig.getAppDependencies().getRepositories(), this.remoteAppConfig.getAppDependencies().getResources().get(0).getRelativeUrl(), Repo.class, false);
                Repo rr = this.remoteAppConfig.getAppResources();
                rr.setRepositories(DesktopUtilZone.removeRuZoneFromOther(this.country, rr.getRepositories()));
                resources = this.gsonService.getObjectByUrls(this.remoteAppConfig.getAppResources().getRepositories(), this.remoteAppConfig.getAppResources().getResources().get(0).getRelativeUrl(), Repo.class, false);
                Repo rjr = this.remoteAppConfig.getJavaRepo();
                rjr.setRepositories(DesktopUtilZone.removeRuZoneFromOther(this.country, rjr.getRepositories()));
                this.jvm = this.gsonService.getObjectByUrls(this.remoteAppConfig.getJavaRepo().getRepositories(), this.remoteAppConfig.getJavaRepo().getResources().get(0).getRelativeUrl(), JVMConfig.class, false);
            } else {
                log.info("No Internet connection");
                if (Objects.nonNull(this.appLocalConfig)) {
                    this.remoteAppConfig = this.gsonService.getLocalObject(this.starterConfig.getServerFile(), this.starterConfig.getServerFileConfig(this.starterConfig, this.appLocalConfig.getCurrentAppVersion()), AppConfig.class);
                }
                if (Objects.isNull(this.remoteAppConfig)) {
                    this.remoteAppConfig = this.gsonService.getLocalObject(this.starterConfig.getServerFile(), serverFileUrn, AppConfig.class);
                }
                if (Objects.isNull(this.remoteAppConfig)) {
                    this.eventBus.post(new ExceptionMessage(this.bundle.getString("net.problem")));
                    System.exit(-1);
                }
                Repo dep = this.remoteAppConfig.getAppDependencies();
                this.dependencis = this.gsonService.getLocalObject(dep.getRepositories(), dep.getResources().get(0).getRelativeUrl(), Repo.class);
                Repo res = this.remoteAppConfig.getAppResources();
                resources = this.gsonService.getLocalObject(res.getRepositories(), res.getResources().get(0).getRelativeUrl(), Repo.class);
                Repo javaRepo = this.remoteAppConfig.getJavaRepo();
                this.jvm = this.gsonService.getLocalObject(javaRepo.getRepositories(), javaRepo.getResources().get(0).getRelativeUrl(), JVMConfig.class);
                this.remoteAppConfigDefault = this.remoteAppConfig;
            }
            try {
                this.appLocalConfig = this.fileMapperService.read("starter.json", AppLocalConfig.class);
            }
            catch (Exception e) {
                log.error("can't read default config {}", (Object)"starter.json", (Object)e);
            }
            if (this.appLocalConfig == null) {
                this.appLocalConfig = new AppLocalConfig();
            }
            if (Objects.isNull(this.appLocalConfig.getCurrentAppVersion())) {
                this.appLocalConfig.setCurrentAppVersion(this.remoteAppConfig.getAppVersion());
                this.starterStatusFrame.setNewVersionText(this.appLocalConfig.getCurrentAppVersion());
                this.fileMapperService.write(this.appLocalConfig, "starter.json");
            }
            if (Objects.nonNull(this.starterConfig.getVersion())) {
                this.appLocalConfig.setCurrentAppVersion(this.starterConfig.getVersion());
                this.fileMapperService.write(this.appLocalConfig, "starter.json");
            }
            Repo fileRepo = this.remoteAppConfig.getAppFileRepo();
            this.java = this.jvm.getJvms().get((Object)this.osType).get((Object)this.osArc).get(DownloaderJavaContainer.JRE_DEFAULT);
            this.java.setRepositories(DesktopUtilZone.removeRuZoneFromOther(this.country, this.java.getRepositories()));
            ArrayList<Repo> list = Lists.newArrayList(fileRepo, this.dependencis, resources);
            PostHandlerImpl postHandler = new PostHandlerImpl();
            for (Repo repo : list) {
                repo.setRepositories(DesktopUtilZone.removeRuZoneFromOther(this.country, repo.getRepositories()));
                container.containerAllSize(repo);
                container.filterNotExistResoursesAndSetRepo(repo, this.workDir);
                container.setDestinationRepositories(this.workDir);
                container.setHandlers(Arrays.asList(postHandler));
                downloader.addContainer(container);
            }
            DownloaderJavaContainer jreContainer = new DownloaderJavaContainer(this.fileMapperService, this.workDir, DownloaderJavaContainer.JRE_CONFIG);
            ArchiveHandler archiveHandler = new ArchiveHandler(this.fileMapperService, DownloaderJavaContainer.JRE_CONFIG);
            jreContainer.containerAllSize(this.java);
            jreContainer.filterNotExistResoursesAndSetRepo(this.java, this.workDir);
            jreContainer.setDestinationRepositories(this.workDir);
            jreContainer.setHandlers(Arrays.asList(postHandler, archiveHandler));
            downloader.addContainer(jreContainer);
            downloader.startDownload(true);
        }
        finally {
            DesktopUtil.diactivateDoubleDownloadingResourcesLock();
        }
        log.info("loading is complete");
    }

    private void updateApp(GsonService gsonService, FileMapperService fileMapperService) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        this.eventBus.register(this.starterStatusFrame);
        StringVersionComparator versionComparator = new StringVersionComparator();
        if (Objects.nonNull(this.appLocalConfig) && Objects.nonNull(this.appLocalConfig.getCurrentAppVersion()) && versionComparator.compare(this.appLocalConfig.getCurrentAppVersion(), this.remoteAppConfig.getAppVersion()) == -1 && !GraphicsEnvironment.isHeadless()) {
            if (this.appLocalConfig.isSkippedVersion(this.remoteAppConfig.getAppVersion())) {
                this.remoteAppConfig = gsonService.getObjectByUrls(this.starterConfig.getServerFile(), this.starterConfig.getServerFileConfig(this.starterConfig, this.appLocalConfig.getCurrentAppVersion()), AppConfig.class, false);
            } else {
                try {
                    Update update = gsonService.getObjectByUrls(this.starterConfig.getServerFile(), "additionalUpdateConfiguration-1.1.json", Update.class, false);
                    this.appLocalConfig.setCountry(update.getUserCountry());
                    fileMapperService.write(this.appLocalConfig, "starter.json");
                    UpdaterFormController view = new UpdaterFormController(update, this.appLocalConfig, this.remoteAppConfig, fileMapperService, gsonService, this.bundle, this.requestConfig);
                    boolean updated = view.getResult(update);
                    if (view.getChoose() == -1) {
                        System.exit(-1);
                    } else if (view.getChoose() == 0 || !updated) {
                        this.remoteAppConfig = gsonService.getObjectByUrls(this.starterConfig.getServerFile(), this.starterConfig.getServerFileConfig(this.starterConfig, this.appLocalConfig.getCurrentAppVersion()), AppConfig.class, true);
                        fileMapperService.write(this.appLocalConfig, "starter.json");
                    } else if (view.getChoose() == 1 || view.getChoose() == 2) {
                        this.appLocalConfig.setCurrentAppVersion(this.remoteAppConfig.getAppVersion());
                        fileMapperService.write(this.appLocalConfig, "starter.json");
                    }
                }
                catch (Exception e) {
                    log.error("error", e);
                }
            }
        }
    }

    public void runApp() throws IOException, InterruptedException {
        log.info("Start application {} ", (Object)this.workDir);
        StringVersionComparator versionComparator = new StringVersionComparator();
        Path jre = DesktopUtil.getJavaRun(Paths.get(this.workDir, DownloaderJavaContainer.JRE_DEFAULT, this.java.getJreDirectoryName()));
        JavaProcessHelper javaProcess = new JavaProcessHelper(String.valueOf(jre), new File(this.workDir), this.eventBus);
        String classPath = DesktopUtil.convertListToString(File.pathSeparator, javaProcess.librariesForRunning(this.workDir, this.remoteAppConfig.getAppFileRepo(), this.dependencis));
        javaProcess.addCommands(this.remoteAppConfig.getJvmArguments());
        javaProcess.addCommand("-cp", classPath);
        javaProcess.addCommand(this.remoteAppConfig.getMainClass());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("starterConfig", Paths.get(this.workDir, "starter.json").toAbsolutePath().toString());
        boolean flag = versionComparator.compare(this.appLocalConfig.getCurrentAppVersion(), this.remoteAppConfigDefault.getAppVersion()) == -1;
        map.put("requireUpdate", "" + flag);
        if (Objects.nonNull(this.appLocalConfig.getCountry())) {
            map.put("country", this.appLocalConfig.getCountry());
        }
        map.put("currentAppVersion", this.appLocalConfig.getCurrentAppVersion());
        this.fileMapperService.write(this.domainAvailability, "domainAvailability.json");
        map.put("starterDomainAvailability", Paths.get(this.workDir, "domainAvailability.json").toAbsolutePath().toString());
        StringSubstitutor substitutor = new StringSubstitutor(map);
        javaProcess.addCommands(this.remoteAppConfig.getAppArguments().stream().map(s2 -> substitutor.replace((String)s2)).collect(Collectors.toList()));
        javaProcess.start();
        if (this.starterConfig.isStop()) {
            javaProcess.destroyProcess();
        }
    }

    public void updateApplication() {
        try {
            this.updateCore.checkUpdates(this.osType);
        }
        catch (HashSumAndSizeError t1) {
            String s2 = String.format(this.bundle.getString("upload.error.hash.sum"), t1.getUri(), t1.getLocalPath());
            this.eventBus.post(new ExceptionMessage(s2, t1.getUri()));
        }
        catch (Exception e) {
            log.error("promlem with update application ", e);
        }
    }

    public FileMapperService getFileMapperService() {
        return this.fileMapperService;
    }
}

