#!/sbin/sh

# Copyright (C) 2021-2022 KonstaKANG
# fdisk binary from https://forum.xda-developers.com/android/help/how-to-boot-sd-card-qmobile-z8-bricked-t3712171

# detect storage device
if [ -b /dev/block/mmcblk0 ]; then
  DEVICE=mmcblk0
  PARTITION=p4
else
  DEVICE=sda
  PARTITION=4
fi
echo "Resizing /dev/block/${DEVICE}${PARTITION}" > /tmp/resize.log

# unmount partitions
umount /data
umount /sdcard

# remove existing data partition and create new partition table entry
(
echo d
echo 4
echo n
echo p
echo
echo
echo n
echo w
) | /tmp/fdisk /dev/block/${DEVICE} >> /tmp/resize.log 2>&1
if [ $? != "0" ]; then
  exit 1
fi
sleep 1

# calculate new filesystem size leaving 16kb for crypto footer
CURSIZE=$(/tmp/fdisk -l /dev/block/${DEVICE} | grep ${DEVICE}${PARTITION} | awk '{print $4}')
NEWSIZE=$(expr \( ${CURSIZE} \* 512 - 16384 \) / 4096)
echo ${CURSIZE} >> /tmp/resize.log
echo ${NEWSIZE} >> /tmp/resize.log

# resize filesystem
resize2fs -f /dev/block/${DEVICE}${PARTITION} ${NEWSIZE} >> /tmp/resize.log 2>&1
if [ $? != "0" ]; then
  exit 1
fi

exit 0
