#!/sbin/sh

# Copyright (C) 2021-2024 KonstaKANG
# fdisk binary from https://forum.xda-developers.com/android/help/how-to-boot-sd-card-qmobile-z8-bricked-t3712171

# Detect storage device
if [ $(cat /proc/device-tree/firmware/android/bootdevice) == "sdcard" ] && [ -b /dev/block/mmcblk0 ]; then
  DEVICE=mmcblk0
  PARTITION=p4
elif [ $(cat /proc/device-tree/firmware/android/bootdevice) == "nvme" ] && [ -b /dev/block/nvme0n1 ]; then
  DEVICE=nvme0n1
  PARTITION=p4
elif [ $(cat /proc/device-tree/firmware/android/bootdevice) == "usb" ] && [ -b /dev/block/sda ]; then
  DEVICE=sda
  PARTITION=4
else
  echo "Couldn't find storage device!" > /tmp/resize.log
  exit 1
fi
echo "Resizing /dev/block/${DEVICE}${PARTITION}" > /tmp/resize.log

# Unmount partitions
umount /data
umount /sdcard

# Remove existing data partition and create new partition table entry
(
echo d
echo 4
echo n
echo p
echo
echo
echo n
echo w
) | /tmp/fdisk /dev/block/${DEVICE} >> /tmp/resize.log 2>&1
if [ $? != "0" ]; then
  exit 1
fi
sleep 1

# Calculate new filesystem size
CURRENT_PARTITION_SIZE=$(/tmp/fdisk -l /dev/block/${DEVICE} | grep ${DEVICE}${PARTITION} | awk '{print $4}')
NEW_FS_SIZE=$(expr \( ${CURRENT_PARTITION_SIZE} \* 512 \) / 4096)
echo ${CURRENT_PARTITION_SIZE} >> /tmp/resize.log
echo ${NEW_FS_SIZE} >> /tmp/resize.log

# Resize filesystem
resize2fs -f /dev/block/${DEVICE}${PARTITION} ${NEW_FS_SIZE} >> /tmp/resize.log 2>&1
if [ $? != "0" ]; then
  exit 1
fi

exit 0
