#!/sbin/sh

# Copyright (C) 2021-2025 KonstaKANG
# Magisk binaries from https://github.com/topjohnwu/Magisk/releases/tag/v29.0

cleanup()
{
  rm /boot/ramdisk.cpio
  rm /boot/ramdisk.cpio.orig
}

# Set environment
export KEEPVERITY=false
export KEEPFORCEENCRYPT=false
export PATCHVBMETAFLAG=false
echo "KEEPVERITY=${KEEPVERITY}" > /tmp/config
echo "KEEPFORCEENCRYPT=${KEEPFORCEENCRYPT}" >> /tmp/config
echo "PATCHVBMETAFLAG=${PATCHVBMETAFLAG}" >> /tmp/config

# Find ramdisk
if [ -f /boot/ramdisk.img ] && [ -f /boot/ramdisk-boot.img ]; then
  RAMDISK=ramdisk-boot.img
  echo "Using ${RAMDISK}" > /tmp/magisk.log
elif [ -f /boot/ramdisk.img ] && [ -f /boot/ramdisk-recovery.img ]; then
  RAMDISK=ramdisk.img
  echo "Using ${RAMDISK}" > /tmp/magisk.log
else
  echo "Couldn't find ramdisk!" > /tmp/magisk.log
  exit 1
fi

# Backup original ramdisk image & extract cpio
if [ ! -f /boot/ramdisk-orig.img ]; then
  cp /boot/${RAMDISK} /boot/ramdisk-orig.img
fi
gzip -d < /boot/${RAMDISK} > /boot/ramdisk.cpio
cp /boot/ramdisk.cpio /boot/ramdisk.cpio.orig

# Check that ramdisk is unpatched for Magisk
/tmp/magiskboot cpio /boot/ramdisk.cpio test
# 0:stock 1:Magisk 2:unsupported (phh, SuperSU, Xposed)
if [ $? != "0" ]; then
  echo "Ramdisk already patched for Magisk!" >> /tmp/magisk.log
  cleanup
  exit 1
fi

# Compress binaries
/tmp/magiskboot compress=xz /tmp/magisk /tmp/magisk.xz
/tmp/magiskboot compress=xz /tmp/stub.apk /tmp/stub.xz
/tmp/magiskboot compress=xz /tmp/init-ld /tmp/init-ld.xz

# Patch ramdisk cpio for Magisk
/tmp/magiskboot cpio /boot/ramdisk.cpio \
  "add 0750 init /tmp/magiskinit" \
  "mkdir 0750 overlay.d" \
  "mkdir 0750 overlay.d/sbin" \
  "add 0644 overlay.d/sbin/magisk.xz /tmp/magisk.xz" \
  "add 0644 overlay.d/sbin/stub.xz /tmp/stub.xz" \
  "add 0644 overlay.d/sbin/init-ld.xz /tmp/init-ld.xz" \
  "patch" \
  "backup /boot/ramdisk.cpio.orig" \
  "mkdir 000 .backup" \
  "add 000 .backup/.magisk /tmp/config" \
  >> /tmp/magisk.log 2>&1

# Check that ramdisk was patched successfully & cleanup
/tmp/magiskboot cpio /boot/ramdisk.cpio test
# 0:stock 1:Magisk 2:unsupported (phh, SuperSU, Xposed)
if [ $? != "1" ]; then
  echo "Failed to patch ramdisk for Magisk!" >> /tmp/magisk.log
  cleanup
  exit 1
else
  echo "Ramdisk successfully patched for Magisk!" >> /tmp/magisk.log
  gzip < /boot/ramdisk.cpio > /boot/${RAMDISK}
  cleanup
  exit 0
fi
